/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.browser;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class BrowserChartConfigurationEditor
implements IObjectPropertyConfigurator<DashboardItemConfiguration, DashboardItemConfiguration> {
    private Text urlText;
    private Button resolveVariablesCheck;

    public void createControl(@NotNull Composite composite, DashboardItemConfiguration itemDescriptor, @NotNull Runnable propertyChangeListener) {
        boolean readOnly = !itemDescriptor.isCustom();
        int baseStyle = !readOnly ? 0 : 8;
        this.urlText = UIUtils.createLabelText((Composite)composite, (String)"URL", (String)CommonUtils.notEmpty((String)itemDescriptor.getDescription()), (int)(0xA42 | baseStyle));
        this.urlText.addModifyListener(e -> propertyChangeListener.run());
        GridData gd = new GridData(1808);
        gd.heightHint = UIUtils.getFontHeight((Control)this.urlText) * 8;
        gd.widthHint = UIUtils.getFontHeight((Control)this.urlText) * 50;
        this.urlText.setLayoutData((Object)gd);
        this.resolveVariablesCheck = UIUtils.createCheckbox((Composite)composite, (String)"Resolve variables", (String)"Resolve environment and database-specific variables in URL", (boolean)itemDescriptor.isResolveVariables(), (int)2);
    }

    public void loadSettings(@NotNull DashboardItemConfiguration itemConfiguration) {
        this.urlText.setText(CommonUtils.notEmpty((String)itemConfiguration.getDashboardURL()));
        this.resolveVariablesCheck.setSelection(itemConfiguration.isResolveVariables());
    }

    public void saveSettings(@NotNull DashboardItemConfiguration itemDescriptor) {
        itemDescriptor.setDashboardURL(this.urlText.getText());
        itemDescriptor.setResolveVariables(this.resolveVariablesCheck.getSelection());
    }

    public void resetSettings(@NotNull DashboardItemConfiguration itemConfiguration) {
    }

    public boolean isComplete() {
        return !this.urlText.getText().isEmpty();
    }
}

