/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class PutOutsideColonyMessage
extends AttributeMessage {
    public static final String TAG = "putOutsideColony";
    private static final String UNIT_TAG = "unit";

    public PutOutsideColonyMessage(Unit unit) {
        super(TAG, UNIT_TAG, unit.getId());
    }

    public PutOutsideColonyMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!unit.hasTile()) {
            return serverPlayer.clientError("Unit is not on the map: " + unitId);
        }
        if (unit.getColony() == null) {
            return serverPlayer.clientError("Unit is not in a colony: " + unitId);
        }
        return this.igc(freeColServer).putOutsideColony(serverPlayer, unit);
    }
}

