/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.HashValue128;
import com.dynatrace.hash4j.internal.ByteArrayUtil;

public final class HashValues {
    private static final char[] HEX_DIGITS_LOWER_CASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HashValues() {
    }

    private static char getHexForLeastSignificant4Bits(long l) {
        return HEX_DIGITS_LOWER_CASE[0xF & (int)l];
    }

    public static byte[] toByteArray(int hashValue) {
        byte[] b = new byte[4];
        ByteArrayUtil.setInt(b, 0, hashValue);
        return b;
    }

    public static byte[] toByteArray(long hashValue) {
        byte[] b = new byte[8];
        ByteArrayUtil.setLong(b, 0, hashValue);
        return b;
    }

    public static byte[] toByteArray(HashValue128 hashValue) {
        byte[] b = new byte[16];
        ByteArrayUtil.setLong(b, 0, hashValue.getLeastSignificantBits());
        ByteArrayUtil.setLong(b, 8, hashValue.getMostSignificantBits());
        return b;
    }

    public static String toHexString(int hashValue) {
        return new String(new char[]{HashValues.getHexForLeastSignificant4Bits(hashValue >>> 28), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 24), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 20), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 16), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 12), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 8), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 4), HashValues.getHexForLeastSignificant4Bits(hashValue)});
    }

    public static String toHexString(long hashValue) {
        return new String(new char[]{HashValues.getHexForLeastSignificant4Bits(hashValue >>> 60), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 56), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 52), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 48), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 44), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 40), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 36), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 32), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 28), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 24), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 20), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 16), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 12), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 8), HashValues.getHexForLeastSignificant4Bits(hashValue >>> 4), HashValues.getHexForLeastSignificant4Bits(hashValue)});
    }

    public static String toHexString(HashValue128 hashValue) {
        long mostSignificantBits = hashValue.getMostSignificantBits();
        long leastSignificantBits = hashValue.getLeastSignificantBits();
        return new String(new char[]{HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 60), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 56), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 52), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 48), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 44), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 40), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 36), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 32), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 28), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 24), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 20), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 16), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 12), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 8), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits >>> 4), HashValues.getHexForLeastSignificant4Bits(mostSignificantBits), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 60), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 56), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 52), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 48), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 44), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 40), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 36), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 32), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 28), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 24), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 20), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 16), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 12), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 8), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits >>> 4), HashValues.getHexForLeastSignificant4Bits(leastSignificantBits)});
    }
}

