/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import twitter4j.Authorization;
import twitter4j.DirectMessagesResourcesImpl;
import twitter4j.FavoritesResourcesImpl;
import twitter4j.FriendsFollowersResourcesImpl;
import twitter4j.HelpResourcesImpl;
import twitter4j.HttpClient;
import twitter4j.HttpParameter;
import twitter4j.ListsResourcesImpl;
import twitter4j.ObjectFactory;
import twitter4j.PlacesGeoResourcesImpl;
import twitter4j.RateLimitStatusEvent;
import twitter4j.SavedSearchesResourcesImpl;
import twitter4j.SearchResourceImpl;
import twitter4j.SpamReportingResourceImpl;
import twitter4j.TimelinesResourcesImpl;
import twitter4j.TrendsResourcesImpl;
import twitter4j.TweetsResourcesImpl;
import twitter4j.TwitterStreamImpl;
import twitter4j.UsersResourcesImpl;
import twitter4j.v1.ConnectionLifeCycleListener;
import twitter4j.v1.DirectMessagesResources;
import twitter4j.v1.FavoritesResources;
import twitter4j.v1.FriendsFollowersResources;
import twitter4j.v1.HelpResources;
import twitter4j.v1.ListsResources;
import twitter4j.v1.PlacesGeoResources;
import twitter4j.v1.RawStreamListener;
import twitter4j.v1.SavedSearchesResources;
import twitter4j.v1.SearchResource;
import twitter4j.v1.SpamReportingResource;
import twitter4j.v1.StreamListener;
import twitter4j.v1.TimelinesResources;
import twitter4j.v1.TrendsResources;
import twitter4j.v1.TweetsResources;
import twitter4j.v1.TwitterStream;
import twitter4j.v1.TwitterV1;
import twitter4j.v1.UsersResources;

class TwitterV1Impl
implements TwitterV1 {
    private final PlacesGeoResourcesImpl placeGeoResources;
    private final TimelinesResources timelinesResources;
    private final TweetsResources tweetsResources;
    private final SearchResource searchResource;
    private final DirectMessagesResources directMessagesResources;
    private final FriendsFollowersResources friendsFollowersResources;
    private final SavedSearchesResources savedSearchesResources;
    private final FavoritesResources favoritesResources;
    private final ListsResources listResources;
    private final HelpResources helpResources;
    private final SpamReportingResource spamReportingResource;
    private final TrendsResources trendResources;
    private final UsersResources usersResources;
    private final TwitterStream twitterStream;

    TwitterV1Impl(HttpClient http, ObjectFactory factory, String restBaseURL, String streamBaseURL, String uploadBaseURL, Authorization auth, boolean mbeanEnabled, HttpParameter[] IMPLICIT_PARAMS, String IMPLICIT_PARAMS_STR, List<Consumer<RateLimitStatusEvent>> rateLimitStatusListeners, List<Consumer<RateLimitStatusEvent>> rateLimitReachedListeners, String streamThreadName, List<ConnectionLifeCycleListener> connectionLifeCycleListeners, List<StreamListener> streamListeners, List<RawStreamListener> rawStreamListeners, boolean jsonStoreEnabled, boolean prettyDebug, boolean stallWarningsEnabled) {
        this.helpResources = new HelpResourcesImpl(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
        this.spamReportingResource = new SpamReportingResourceImpl(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
        this.trendResources = new TrendsResourcesImpl(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
        this.placeGeoResources = new PlacesGeoResourcesImpl(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
        this.savedSearchesResources = new SavedSearchesResourcesImpl(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
        this.listResources = new ListsResourcesImpl(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
        this.timelinesResources = new TimelinesResourcesImpl(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
        this.tweetsResources = new TweetsResourcesImpl(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners, uploadBaseURL);
        this.searchResource = new SearchResourceImpl(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
        this.directMessagesResources = new DirectMessagesResourcesImpl(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
        this.friendsFollowersResources = new FriendsFollowersResourcesImpl(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
        this.favoritesResources = new FavoritesResourcesImpl(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
        this.usersResources = new UsersResourcesImpl(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
        this.twitterStream = new TwitterStreamImpl(streamBaseURL, streamThreadName, connectionLifeCycleListeners, streamListeners, rawStreamListeners, jsonStoreEnabled, prettyDebug, stallWarningsEnabled, http, auth);
    }

    @Override
    public TimelinesResources timelines() {
        return this.timelinesResources;
    }

    @Override
    public TweetsResources tweets() {
        return this.tweetsResources;
    }

    @Override
    public SearchResource search() {
        return this.searchResource;
    }

    @Override
    public DirectMessagesResources directMessages() {
        return this.directMessagesResources;
    }

    @Override
    public FriendsFollowersResources friendsFollowers() {
        return this.friendsFollowersResources;
    }

    @Override
    public UsersResources users() {
        return this.usersResources;
    }

    @Override
    public FavoritesResources favorites() {
        return this.favoritesResources;
    }

    @Override
    public ListsResources list() {
        return this.listResources;
    }

    @Override
    public SavedSearchesResources savedSearches() {
        return this.savedSearchesResources;
    }

    @Override
    public PlacesGeoResources placesGeo() {
        return this.placeGeoResources;
    }

    @Override
    public TrendsResources trends() {
        return this.trendResources;
    }

    @Override
    public SpamReportingResource spamReporting() {
        return this.spamReportingResource;
    }

    @Override
    public HelpResources help() {
        return this.helpResources;
    }

    @Override
    public TwitterStream stream() {
        return this.twitterStream;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterV1Impl twitterV1 = (TwitterV1Impl)o;
        return Objects.equals(this.placeGeoResources, twitterV1.placeGeoResources) && Objects.equals(this.timelinesResources, twitterV1.timelinesResources) && Objects.equals(this.tweetsResources, twitterV1.tweetsResources) && Objects.equals(this.searchResource, twitterV1.searchResource) && Objects.equals(this.directMessagesResources, twitterV1.directMessagesResources) && Objects.equals(this.friendsFollowersResources, twitterV1.friendsFollowersResources) && Objects.equals(this.savedSearchesResources, twitterV1.savedSearchesResources) && Objects.equals(this.favoritesResources, twitterV1.favoritesResources) && Objects.equals(this.listResources, twitterV1.listResources) && Objects.equals(this.helpResources, twitterV1.helpResources) && Objects.equals(this.spamReportingResource, twitterV1.spamReportingResource) && Objects.equals(this.trendResources, twitterV1.trendResources) && Objects.equals(this.usersResources, twitterV1.usersResources) && Objects.equals(this.twitterStream, twitterV1.twitterStream);
    }

    public int hashCode() {
        return Objects.hash(this.placeGeoResources, this.timelinesResources, this.tweetsResources, this.searchResource, this.directMessagesResources, this.friendsFollowersResources, this.savedSearchesResources, this.favoritesResources, this.listResources, this.helpResources, this.spamReportingResource, this.trendResources, this.usersResources, this.twitterStream);
    }

    public String toString() {
        return "TwitterV1Impl{placeGeoResources=" + this.placeGeoResources + ", timelinesResources=" + this.timelinesResources + ", tweetsResources=" + this.tweetsResources + ", searchResource=" + this.searchResource + ", directMessagesResources=" + this.directMessagesResources + ", friendsFollowersResources=" + this.friendsFollowersResources + ", savedSearchesResources=" + this.savedSearchesResources + ", favoritesResources=" + this.favoritesResources + ", listResources=" + this.listResources + ", helpResources=" + this.helpResources + ", spamReportingResource=" + this.spamReportingResource + ", trendResources=" + this.trendResources + ", usersResources=" + this.usersResources + ", twitterStream=" + this.twitterStream + '}';
    }
}

