/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg.keybox;

import java.io.IOException;
import java.util.List;
import org.bouncycastle.gpg.keybox.Blob;
import org.bouncycastle.gpg.keybox.BlobType;
import org.bouncycastle.gpg.keybox.BlobVerifier;
import org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import org.bouncycastle.gpg.keybox.KeyInformation;
import org.bouncycastle.gpg.keybox.UserID;

public class KeyBlob
extends Blob {
    private final int blobFlags;
    private final int keyNumber;
    private final List<KeyInformation> keyInformation;
    private final byte[] serialNumber;
    private final int numberOfUserIDs;
    private final List<UserID> userIds;
    private final int numberOfSignatures;
    private final List<Long> expirationTime;
    private final int assignedOwnerTrust;
    private final int allValidity;
    private final long recheckAfter;
    private final long newestTimestamp;
    private final long blobCreatedAt;
    private final byte[] keyBytes;
    private final byte[] reserveBytes;
    private final byte[] checksum;

    protected KeyBlob(int base, long length, BlobType type, int version, int blobFlags, int keyNumber, List<KeyInformation> keyInformation, byte[] serialNumber, int numberOfUserIDs, List<UserID> userIds, int numberOfSignatures, List<Long> expirationTime, int assignedOwnerTrust, int allValidity, long recheckAfter, long newestTimestamp, long blobCreatedAt, byte[] keyBytes, byte[] reserveBytes, byte[] checksum) {
        super(base, length, type, version);
        this.blobFlags = blobFlags;
        this.keyNumber = keyNumber;
        this.keyInformation = keyInformation;
        this.serialNumber = serialNumber;
        this.numberOfUserIDs = numberOfUserIDs;
        this.userIds = userIds;
        this.numberOfSignatures = numberOfSignatures;
        this.expirationTime = expirationTime;
        this.assignedOwnerTrust = assignedOwnerTrust;
        this.allValidity = allValidity;
        this.recheckAfter = recheckAfter;
        this.newestTimestamp = newestTimestamp;
        this.blobCreatedAt = blobCreatedAt;
        this.keyBytes = keyBytes;
        this.reserveBytes = reserveBytes;
        this.checksum = checksum;
    }

    static void verifyDigest(int base, long length, KeyBoxByteBuffer buffer, BlobVerifier blobVerifier) throws IOException {
        byte[] blobDigest;
        byte[] blobData = buffer.rangeOf(base, (int)((long)base + length - 20L));
        if (!blobVerifier.isMatched(blobData, blobDigest = buffer.rangeOf((int)((long)base + length - 20L), (int)((long)base + length)))) {
            throw new IOException("Blob with base offset of " + base + " has incorrect digest.");
        }
    }

    public int getBlobFlags() {
        return this.blobFlags;
    }

    public int getKeyNumber() {
        return this.keyNumber;
    }

    public List<KeyInformation> getKeyInformation() {
        return this.keyInformation;
    }

    public byte[] getSerialNumber() {
        return this.serialNumber;
    }

    public int getNumberOfUserIDs() {
        return this.numberOfUserIDs;
    }

    public List<UserID> getUserIds() {
        return this.userIds;
    }

    public int getNumberOfSignatures() {
        return this.numberOfSignatures;
    }

    public List<Long> getExpirationTime() {
        return this.expirationTime;
    }

    public int getAssignedOwnerTrust() {
        return this.assignedOwnerTrust;
    }

    public int getAllValidity() {
        return this.allValidity;
    }

    public long getRecheckAfter() {
        return this.recheckAfter;
    }

    public long getNewestTimestamp() {
        return this.newestTimestamp;
    }

    public long getBlobCreatedAt() {
        return this.blobCreatedAt;
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public byte[] getReserveBytes() {
        return this.reserveBytes;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }
}

