/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.opensearch.OpenSearchException;
import org.opensearch.ingest.common.AbstractStringProcessor;

public final class HtmlStripProcessor
extends AbstractStringProcessor<String> {
    public static final String TYPE = "html_strip";

    HtmlStripProcessor(String tag, String description, String field, boolean ignoreMissing, String targetField) {
        super(tag, description, ignoreMissing, targetField, field);
    }

    @Override
    protected String process(String value) {
        if (!value.contains("<") || !value.contains(">")) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        try (HTMLStripCharFilter filter = new HTMLStripCharFilter((Reader)new StringReader(value));){
            int ch;
            while ((ch = filter.read()) != -1) {
                builder.append((char)ch);
            }
        }
        catch (IOException e) {
            throw new OpenSearchException((Throwable)e);
        }
        return builder.toString();
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    extends AbstractStringProcessor.Factory {
        public Factory() {
            super(HtmlStripProcessor.TYPE);
        }

        protected HtmlStripProcessor newProcessor(String tag, String description, Map<String, Object> config, String field, boolean ignoreMissing, String targetField) {
            return new HtmlStripProcessor(tag, description, field, ignoreMissing, targetField);
        }
    }
}

