/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.util.Collection;
import java.util.Set;
import org.opensearch.timeseries.Name;

public enum ForecastSuggestName implements Name
{
    INTERVAL("forecast_interval"),
    HORIZON("horizon"),
    HISTORY("history"),
    WINDOW_DELAY("window_delay");

    private String name;

    private ForecastSuggestName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static ForecastSuggestName getName(String name) {
        switch (name) {
            case "forecast_interval": {
                return INTERVAL;
            }
            case "horizon": {
                return HORIZON;
            }
            case "history": {
                return HISTORY;
            }
            case "window_delay": {
                return WINDOW_DELAY;
            }
        }
        throw new IllegalArgumentException("The given suggest type doesn't exist");
    }

    public static Set<ForecastSuggestName> getNames(Collection<String> names) {
        return Name.getNameFromCollection(names, ForecastSuggestName::getName);
    }
}

