/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.tasks;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.tasks.TaskInfoBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TaskGroup
extends TaskInfoBase
implements ToCopyableBuilder<Builder, TaskGroup> {
    @Nonnull
    private final List<TaskGroup> children;
    public static final JsonpDeserializer<TaskGroup> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TaskGroup::setupTaskGroupDeserializer);

    private TaskGroup(Builder builder) {
        super(builder);
        this.children = ApiTypeHelper.unmodifiable(builder.children);
    }

    public static TaskGroup of(Function<Builder, ObjectBuilder<TaskGroup>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<TaskGroup> children() {
        return this.children;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.children)) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (TaskGroup item0 : this.children) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTaskGroupDeserializer(ObjectDeserializer<Builder> op) {
        TaskGroup.setupTaskInfoBaseDeserializer(op);
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "children");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.children);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskGroup other = (TaskGroup)o;
        return Objects.equals(this.children, other.children);
    }

    public static class Builder
    extends TaskInfoBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TaskGroup> {
        @Nullable
        private List<TaskGroup> children;

        public Builder() {
        }

        private Builder(TaskGroup o) {
            super(o);
            this.children = Builder._listCopy(o.children);
        }

        private Builder(Builder o) {
            super(o);
            this.children = Builder._listCopy(o.children);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder children(List<TaskGroup> list) {
            this.children = Builder._listAddAll(this.children, list);
            return this;
        }

        @Nonnull
        public final Builder children(TaskGroup value, TaskGroup ... values) {
            this.children = Builder._listAdd(this.children, value, values);
            return this;
        }

        @Nonnull
        public final Builder children(Function<Builder, ObjectBuilder<TaskGroup>> fn) {
            return this.children(fn.apply(new Builder()).build(), new TaskGroup[0]);
        }

        @Override
        @Nonnull
        public TaskGroup build() {
            this._checkSingleUse();
            return new TaskGroup(this);
        }
    }
}

