/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.eventstream;

public enum MessageType {
    ApplicationMessage(0),
    ApplicationError(1),
    Ping(2),
    PingResponse(3),
    Connect(4),
    ConnectAck(5),
    ProtocolError(6),
    ServerError(7);

    private byte enumValue;

    private MessageType(byte enumValue) {
        this.enumValue = enumValue;
    }

    public byte getEnumValue() {
        return this.enumValue;
    }

    public static MessageType fromEnumValue(int enumValue) {
        for (MessageType type : MessageType.values()) {
            if (type.enumValue != enumValue) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown MessageType enum value: " + enumValue);
    }
}

