/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleLoader;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.style.Value;

class Context {
    private final List<StyleSignatureBasic> signatures = new ArrayList<StyleSignatureBasic>();
    private final Map<PName, Value> map = new EnumMap<PName, Value>(PName.class);
    private Context parent;

    private Context() {
    }

    public static Context empty() {
        Context result = new Context();
        result.signatures.add(StyleSignatureBasic.empty());
        return result;
    }

    public Context push(String newString) {
        if (newString.startsWith(":")) {
            newString = newString.substring(1);
        }
        Context result = new Context();
        result.parent = this;
        boolean star = false;
        if (newString.endsWith("*")) {
            newString = newString.substring(0, newString.length() - 1).trim();
            star = true;
        }
        for (String s : newString.split(",")) {
            for (StyleSignatureBasic ssb : this.signatures) {
                SName sname;
                ssb = s.startsWith(".") ? ssb.addStereotype(s) : (s.startsWith("depth(") ? ssb.addLevel(Integer.parseInt(s.replaceAll("\\D", ""))) : ((sname = SName.retrieve(s)) == null ? ssb.addStereotype(s) : ssb.addSName(sname)));
                if (star) {
                    ssb = ssb.addStar();
                }
                result.signatures.add(ssb);
            }
        }
        return result;
    }

    public Context pop() {
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        return this.parent;
    }

    public String toString() {
        return this.signatures.toString();
    }

    public boolean isEmpty() {
        return this.signatures.get(0).isEmpty();
    }

    public Collection<StyleSignatureBasic> toSignatures() {
        return this.signatures;
    }

    public void putInContext(PName key, Value value) {
        this.map.put(key, value);
    }

    public Collection<Style> toStyles() {
        ArrayList<Style> result = new ArrayList<Style>();
        Collection<StyleSignatureBasic> signatures = this.toSignatures();
        for (StyleSignatureBasic signature : signatures) {
            Map<PName, Value> tmp = this.map;
            if (signature.isWithDot()) {
                tmp = StyleLoader.addPriorityForStereotype(tmp);
            }
            if (tmp.size() <= 0) continue;
            result.add(new Style(signature, tmp));
        }
        return result;
    }
}

