/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.XmlReader;
import com.intellij.openapi.extensions.ExtensionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"pluginIdsToIgnoreK2KotlinCompatibility", "", "", "isKotlinPluginK2Mode", "", "isPluginWhichDependsOnKotlinPluginInK2ModeAndItDoesNotSupportK2Mode", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "pluginCanWorkInK2Mode", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nkotlinK2ModeCompatibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kotlinK2ModeCompatibilityChecker.kt\ncom/intellij/ide/plugins/KotlinK2ModeCompatibilityCheckerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1747#2,3:36\n1747#2,3:39\n1549#2:42\n1620#2,3:43\n*S KotlinDebug\n*F\n+ 1 kotlinK2ModeCompatibilityChecker.kt\ncom/intellij/ide/plugins/KotlinK2ModeCompatibilityCheckerKt\n*L\n22#1:36,3\n23#1:39,3\n7#1:42\n7#1:43,3\n*E\n"})
public final class KotlinK2ModeCompatibilityCheckerKt {
    @NotNull
    private static final List<String> pluginIdsToIgnoreK2KotlinCompatibility;

    public static final boolean pluginCanWorkInK2Mode(@NotNull IdeaPluginDescriptorImpl plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        List<ExtensionDescriptor> list = plugin.epNameToExtensions.get("org.jetbrains.kotlin.supportsKotlinK2Mode");
        return (list != null ? !((Collection)list).isEmpty() : false) || pluginIdsToIgnoreK2KotlinCompatibility.contains(plugin.getPluginId().getIdString());
    }

    public static final boolean isKotlinPluginK2Mode() {
        return Boolean.parseBoolean(System.getProperty("idea.kotlin.plugin.use.k2", "false"));
    }

    @ApiStatus.Internal
    public static final boolean isPluginWhichDependsOnKotlinPluginInK2ModeAndItDoesNotSupportK2Mode(@NotNull IdeaPluginDescriptorImpl plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return KotlinK2ModeCompatibilityCheckerKt.isKotlinPluginK2Mode() && !XmlReader.isKotlinPlugin(plugin.getPluginId()) && KotlinK2ModeCompatibilityCheckerKt.isPluginWhichDependsOnKotlinPluginInK2ModeAndItDoesNotSupportK2Mode$nonOptionallyDependsOnKotlinPlugin(plugin) && !KotlinK2ModeCompatibilityCheckerKt.pluginCanWorkInK2Mode(plugin);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isPluginWhichDependsOnKotlinPluginInK2ModeAndItDoesNotSupportK2Mode$nonOptionallyDependsOnKotlinPlugin(IdeaPluginDescriptorImpl $plugin) {
        Object it;
        boolean bl;
        Iterable $this$any$iv = $plugin.pluginDependencies;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (PluginDependency)element$iv;
                boolean bl2 = false;
                if (XmlReader.isKotlinPlugin(((PluginDependency)it).getPluginId()) && !((PluginDependency)it).isOptional()) {
                    return true;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = $plugin.dependencies.plugins;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            it = (ModuleDependenciesDescriptor.PluginReference)element$iv;
            boolean bl4 = false;
        } while (!XmlReader.isKotlinPlugin(((ModuleDependenciesDescriptor.PluginReference)it).id));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static {
        List list;
        List list2;
        char[] cArray;
        Object object = System.getProperty("idea.kotlin.plugin.plugin.ids.to.ignore.k2.compatibility");
        if (object != null && (object = StringsKt.split$default((CharSequence)object, cArray = new char[]{','}, false, 0, 6, null)) != null) {
            void var3_3;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            list2 = (List)var3_3;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        pluginIdsToIgnoreK2KotlinCompatibility = list;
    }
}

