/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.stream.Stream;
import org.keycloak.common.Profile;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.rar.AuthorizationRequestParserProvider;
import org.keycloak.rar.AuthorizationDetails;
import org.keycloak.rar.AuthorizationRequestContext;
import org.keycloak.rar.AuthorizationRequestSource;

public class AuthorizationContextUtil {
    public static AuthorizationRequestContext getAuthorizationRequestContextFromScopes(KeycloakSession session, String scope) {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES)) {
            throw new RuntimeException("The Dynamic Scopes feature is not enabled and the AuthorizationRequestContext hasn't been generated");
        }
        AuthorizationRequestParserProvider clientScopeParser = (AuthorizationRequestParserProvider)session.getProvider(AuthorizationRequestParserProvider.class, "client-scope");
        if (clientScopeParser == null) {
            throw new RuntimeException(String.format("No provider found for authorization requests parser %1s", "client-scope"));
        }
        return clientScopeParser.parseScopes(scope);
    }

    public static AuthorizationRequestContext getAuthorizationRequestContextFromScopesWithClient(KeycloakSession session, String scope) {
        AuthorizationRequestContext authorizationRequestContext = AuthorizationContextUtil.getAuthorizationRequestContextFromScopes(session, scope);
        authorizationRequestContext.getAuthorizationDetailEntries().add(new AuthorizationDetails((ClientScopeModel)session.getContext().getClient()));
        return authorizationRequestContext;
    }

    public static Stream<AuthorizationDetails> getAuthorizationRequestsStreamFromScopesWithClient(KeycloakSession session, String scope) {
        AuthorizationRequestContext authorizationRequestContext = AuthorizationContextUtil.getAuthorizationRequestContextFromScopesWithClient(session, scope);
        return authorizationRequestContext.getAuthorizationDetailEntries().stream();
    }

    public static Stream<ClientScopeModel> getClientScopesStreamFromAuthorizationRequestContextWithClient(KeycloakSession session, String scope) {
        return AuthorizationContextUtil.getAuthorizationRequestContextFromScopesWithClient(session, scope).getAuthorizationDetailEntries().stream().filter(authorizationDetails -> authorizationDetails.getSource() == AuthorizationRequestSource.SCOPE).map(AuthorizationDetails::getClientScope);
    }
}

