from typing import Optional

from pydantic import BaseModel
from sqlalchemy import Column, Integer, ForeignKey, String, Double
from sqlalchemy.orm import relationship

from ..base import Base


class RegionEtwEvents(Base):
    __tablename__ = 'region_etw_events'
    id = Column(Integer, primary_key=True, index=True)
    name = Column(String)
    count = Column(Integer)
    pct = Column(Double)
    type = Column(String)

    region_id = Column(Integer, ForeignKey('region.id'))
    region = relationship('Region', back_populates='region_etw_events')


class RegionEtwEventsInDB(BaseModel):
    name: str
    count: int
    pct: float
    type: str

    class Config:
        from_attributes = True


class RegionEtwEventsCreate(BaseModel):
    id: Optional[int] = None
    name: str
    count: int
    pct: float
    type: str

    class Config:
        from_attributes = True
