/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dot;

public class ProcessState {
    private final String name;
    private final Throwable cause;
    private static final ProcessState TERMINATED_OK = new ProcessState("TERMINATED_OK", null);
    private static final ProcessState TIMEOUT = new ProcessState("TIMEOUT", null);

    private ProcessState(String name, Throwable cause) {
        this.name = name;
        this.cause = cause;
    }

    public String toString() {
        if (this.cause == null) {
            return this.name;
        }
        return this.name + " " + this.cause.toString();
    }

    public static ProcessState TERMINATED_OK() {
        return TERMINATED_OK;
    }

    public static ProcessState TIMEOUT() {
        return TIMEOUT;
    }

    public static ProcessState EXCEPTION(Throwable e) {
        return new ProcessState("EXCEPTION", e);
    }

    public boolean differs(ProcessState other) {
        return !this.name.equals(other.name);
    }

    public boolean equals(Object o) {
        ProcessState other = (ProcessState)o;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Throwable getCause() {
        return this.cause;
    }
}

