/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.truffle;

import com.oracle.graal.python.util.PythonUtils;

public abstract class TruffleStringMigrationHelpers {
    public static Object assertNoJavaString(Object o) {
        assert (!(o instanceof String));
        return o;
    }

    public static Object ensureNoJavaString(Object o) {
        if (o instanceof String) {
            return PythonUtils.toTruffleStringUncached((String)o);
        }
        return o;
    }

    public static boolean isJavaString(Object o) {
        assert (!(o instanceof String));
        return false;
    }

    public static void assertContainsNoJavaString(Object[] elements) {
        assert (!TruffleStringMigrationHelpers.containsJavaString(elements));
    }

    private static boolean containsJavaString(Object[] elements) {
        if (elements == null) {
            return false;
        }
        for (Object o : elements) {
            if (!(o instanceof String)) continue;
            return true;
        }
        return false;
    }
}

