/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.sql.Datum;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public abstract class OracleNamedType
extends OracleType
implements Serializable {
    transient OracleConnection connection;
    SQLName sqlName;
    transient OracleTypeADT parent;
    transient int idx;
    transient TypeDescriptor descriptor;
    String typeNameByUser;
    static String getUserTypeTreeSql;
    String sqlHint;
    static String getAllTypeTreeSql;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;

    protected OracleNamedType() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleNamedType.class, $$$methodRef$$$31, null, new Object[0]);
            }
            this.sqlName = null;
            this.parent = null;
            this.descriptor = null;
            this.sqlHint = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleNamedType.class, $$$methodRef$$$31, null);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleNamedType.class, $$$methodRef$$$31, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleNamedType.class, $$$methodRef$$$31, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleNamedType(String name, OracleConnection conn) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OracleNamedType.class, $$$methodRef$$$32, null, name, conn);
            }
            this.sqlName = null;
            this.parent = null;
            this.descriptor = null;
            this.sqlHint = null;
            this.setConnectionInternal(conn);
            this.typeNameByUser = name;
            this.sqlName = new SQLName(name, conn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleNamedType.class, $$$methodRef$$$32, null);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleNamedType.class, $$$methodRef$$$32, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleNamedType.class, $$$methodRef$$$32, null, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleNamedType(OracleTypeADT parent, int idx, OracleConnection conn) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, OracleNamedType.class, $$$methodRef$$$33, null, parent, idx, conn);
            }
            this.sqlName = null;
            this.parent = null;
            this.descriptor = null;
            this.sqlHint = null;
            this.setConnectionInternal(conn);
            this.parent = parent;
            this.idx = idx;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, OracleNamedType.class, $$$methodRef$$$33, null);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleNamedType.class, $$$methodRef$$$33, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleNamedType.class, $$$methodRef$$$33, null, throwable2);
            }
            throw throwable;
        }
    }

    public String getFullName() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleNamedType.class, $$$methodRef$$$0, this, new Object[0]);
            }
            String string = this.getFullName(false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleNamedType.class, $$$methodRef$$$0, this, string);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleNamedType.class, $$$methodRef$$$0, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleNamedType.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getFullName(boolean bl) throws SQLException {
        boolean bl2 = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void force;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleNamedType.class, $$$methodRef$$$1, this, bl);
            }
            String temp_fullName = null;
            if (force != false || this.sqlName == null) {
                if (this.parent != null && (temp_fullName = this.parent.getAttributeType(this.idx)) != null) {
                    if (bl2) {
                        this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "getFullName going to db.");
                    }
                    this.sqlName = new SQLName(temp_fullName, this.connection);
                } else {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to resolve name").fillInStackTrace();
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleNamedType.class, $$$methodRef$$$1, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            String string = this.sqlName.getName();
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleNamedType.class, $$$methodRef$$$1, this, string);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleNamedType.class, $$$methodRef$$$1, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleNamedType.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getSchemaName() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleNamedType.class, $$$methodRef$$$2, this, new Object[0]);
            }
            if (this.sqlName == null) {
                this.getFullName();
            }
            String string = this.sqlName.getSchema();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleNamedType.class, $$$methodRef$$$2, this, string);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleNamedType.class, $$$methodRef$$$2, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleNamedType.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getSimpleName() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleNamedType.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.sqlName == null) {
                this.getFullName();
            }
            String string = this.sqlName.getSimpleName();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleNamedType.class, $$$methodRef$$$3, this, string);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleNamedType.class, $$$methodRef$$$3, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleNamedType.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean hasName() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleNamedType.class, $$$methodRef$$$4, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.sqlName != null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleNamedType.class, $$$methodRef$$$4, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleNamedType.class, $$$methodRef$$$4, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleNamedType.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public OracleTypeADT getParent() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleNamedType.class, $$$methodRef$$$5, this, new Object[0]);
            }
            OracleTypeADT oracleTypeADT = this.parent;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleNamedType.class, $$$methodRef$$$5, this, oracleTypeADT);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleNamedType.class, $$$methodRef$$$5, this, null);
            }
            return oracleTypeADT;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleNamedType.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setParent(OracleTypeADT oracleTypeADT) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void parent;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleNamedType.class, $$$methodRef$$$6, this, oracleTypeADT);
            }
            this.parent = parent;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleNamedType.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleNamedType.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleNamedType.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getOrder() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleNamedType.class, $$$methodRef$$$7, this, new Object[0]);
            }
            int n2 = this.idx;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleNamedType.class, $$$methodRef$$$7, this, n2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleNamedType.class, $$$methodRef$$$7, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleNamedType.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setOrder(int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void order;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleNamedType.class, $$$methodRef$$$8, this, n2);
            }
            this.idx = order;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleNamedType.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleNamedType.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleNamedType.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    public OracleConnection getConnection() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleNamedType.class, $$$methodRef$$$9, this, new Object[0]);
            }
            OracleConnection oracleConnection = this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleNamedType.class, $$$methodRef$$$9, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleNamedType.class, $$$methodRef$$$9, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleNamedType.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleNamedType.class, $$$methodRef$$$10, this, oracleConnection);
            }
            this.setConnectionInternal((OracleConnection)conn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleNamedType.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleNamedType.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleNamedType.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setConnectionInternal(OracleConnection oracleConnection) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleNamedType.class, $$$methodRef$$$11, this, oracleConnection);
            }
            this.connection = conn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleNamedType.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleNamedType.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleNamedType.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    public Datum unlinearize(byte[] byArray, long l2, Datum datum, int n2, Map map) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleNamedType.class, $$$methodRef$$$12, this, byArray, l2, datum, n2, map);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleNamedType.class, $$$methodRef$$$12, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleNamedType.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    public Datum unlinearize(byte[] byArray, long l2, Datum datum, long l3, int n2, int n3, Map map) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleNamedType.class, $$$methodRef$$$13, this, byArray, l2, datum, l3, n2, n3, map);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleNamedType.class, $$$methodRef$$$13, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleNamedType.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] linearize(Datum datum) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleNamedType.class, $$$methodRef$$$14, this, datum);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, OracleNamedType.class, $$$methodRef$$$14, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleNamedType.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    public TypeDescriptor getDescriptor() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleNamedType.class, $$$methodRef$$$15, this, new Object[0]);
            }
            TypeDescriptor typeDescriptor = this.descriptor;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleNamedType.class, $$$methodRef$$$15, this, typeDescriptor);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleNamedType.class, $$$methodRef$$$15, this, null);
            }
            return typeDescriptor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleNamedType.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDescriptor(TypeDescriptor typeDescriptor) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void desc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleNamedType.class, $$$methodRef$$$16, this, typeDescriptor);
            }
            this.descriptor = desc;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleNamedType.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleNamedType.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleNamedType.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getTypeVersion() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleNamedType.class, $$$methodRef$$$17, this, new Object[0]);
            }
            int n2 = 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleNamedType.class, $$$methodRef$$$17, this, n2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleNamedType.class, $$$methodRef$$$17, this, null);
            }
            return 1;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleNamedType.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleNamedType.class, $$$methodRef$$$18, this, objectOutputStream);
            }
            try {
                void out;
                out.writeUTF(this.getFullName());
            }
            catch (SQLException e2) {
                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, OracleNamedType.class, $$$methodRef$$$18, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleNamedType.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleNamedType.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleNamedType.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void in;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleNamedType.class, $$$methodRef$$$19, this, objectInputStream);
            }
            String name = in.readUTF();
            try {
                this.sqlName = new SQLName(name, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.parent = null;
            this.idx = -1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleNamedType.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleNamedType.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleNamedType.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void fixupConnection(OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleNamedType.class, $$$methodRef$$$20, this, oracleConnection);
            }
            if (this.connection == null) {
                void fixupConn;
                this.setConnection((OracleConnection)fixupConn);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleNamedType.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleNamedType.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleNamedType.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void indent;
            void pw;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleNamedType.class, $$$methodRef$$$21, this, printWriter, n2);
            }
            this.printXML((PrintWriter)pw, (int)indent, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleNamedType.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleNamedType.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleNamedType.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void pw;
            void indent;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleNamedType.class, $$$methodRef$$$22, this, printWriter, n2, bl);
            }
            for (int i2 = 0; i2 < indent; ++i2) {
                pw.print("  ");
            }
            pw.println("<OracleNamedType/>");
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleNamedType.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleNamedType.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleNamedType.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void initNamesRecursively() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            Map typesTreeMap;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleNamedType.class, $$$methodRef$$$23, this, new Object[0]);
            }
            if ((typesTreeMap = this.createTypesTreeMap()).size() > 0) {
                this.initChildNamesRecursively(typesTreeMap);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleNamedType.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleNamedType.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleNamedType.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setNames(String string, String string2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void typeName;
            void schemaName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleNamedType.class, $$$methodRef$$$24, this, string, string2);
            }
            this.sqlName = new SQLName((String)schemaName, (String)typeName, this.connection);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleNamedType.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleNamedType.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleNamedType.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSqlName(SQLName sQLName) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void x2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleNamedType.class, $$$methodRef$$$25, this, sQLName);
            }
            this.sqlName = x2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleNamedType.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleNamedType.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleNamedType.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    public Map createTypesTreeMap() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleNamedType.class, $$$methodRef$$$26, this, new Object[0]);
            }
            Map nodeMap = null;
            String currentUserName = this.connection.getDefaultSchemaNameForNamedTypes();
            if (this.sqlName.getSchema().equals(currentUserName)) {
                nodeMap = this.getNodeMapFromUserTypes();
            }
            if (nodeMap == null) {
                nodeMap = this.getNodeMapFromAllTypes();
            }
            Map map = nodeMap;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleNamedType.class, $$$methodRef$$$26, this, map);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleNamedType.class, $$$methodRef$$$26, this, null);
            }
            return map;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleNamedType.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    String getSqlHint() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleNamedType.class, $$$methodRef$$$27, this, new Object[0]);
            }
            if (this.sqlHint == null) {
                this.sqlHint = this.connection.getVersionNumber() >= 11000 ? "" : "/*+RULE*/";
            }
            String string = this.sqlHint;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleNamedType.class, $$$methodRef$$$27, this, string);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleNamedType.class, $$$methodRef$$$27, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleNamedType.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getNodeMapFromUserTypes() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            Statement pstmt;
            HashMap<SQLName, TypeTreeElement> nodeMap;
            block15: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleNamedType.class, $$$methodRef$$$28, this, new Object[0]);
                }
                nodeMap = new HashMap<SQLName, TypeTreeElement>();
                pstmt = null;
                ResultSet rst = null;
                this.connection.beginNonRequestCalls();
                try {
                    pstmt = this.connection.prepareStatement(this.getSqlHint() + getUserTypeTreeSql);
                    pstmt.setString(1, this.sqlName.getSimpleName());
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        int depth = rst.getInt(1);
                        String parentTypeName = rst.getString(2);
                        String childTypeName = rst.getString(3);
                        int attrNumber = rst.getInt(4);
                        String childTypeOwner = rst.getString(5);
                        if (childTypeOwner != null && !childTypeOwner.equals(this.sqlName.getSchema())) {
                            nodeMap = null;
                            break;
                        }
                        if (parentTypeName.length() <= 0) continue;
                        SQLName parentSqlName = new SQLName(this.sqlName.getSchema(), parentTypeName, this.connection);
                        TypeTreeElement node = null;
                        if (nodeMap.containsKey(parentSqlName)) {
                            node = (TypeTreeElement)nodeMap.get(parentSqlName);
                        } else {
                            node = new TypeTreeElement(this.sqlName.getSchema(), parentTypeName);
                            nodeMap.put(parentSqlName, node);
                        }
                        node.putChild(this.sqlName.getSchema(), childTypeName, attrNumber);
                    }
                    if (rst == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rst != null) {
                        rst.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    this.connection.endNonRequestCalls();
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$28, Level.FINEST, OracleNamedType.class, $$$methodRef$$$28, this, throwable2);
                    }
                    throw throwable2;
                }
                rst.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
            this.connection.endNonRequestCalls();
            HashMap<SQLName, TypeTreeElement> hashMap = nodeMap;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleNamedType.class, $$$methodRef$$$28, this, hashMap);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleNamedType.class, $$$methodRef$$$28, this, null);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleNamedType.class, $$$methodRef$$$28, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getNodeMapFromAllTypes() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            Statement pstmt;
            HashMap<SQLName, TypeTreeElement> nodeMap;
            block15: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleNamedType.class, $$$methodRef$$$29, this, new Object[0]);
                }
                nodeMap = new HashMap<SQLName, TypeTreeElement>();
                pstmt = null;
                ResultSet rst = null;
                this.connection.beginNonRequestCalls();
                try {
                    pstmt = this.connection.prepareStatement(this.getSqlHint() + getAllTypeTreeSql);
                    pstmt.setString(1, this.sqlName.getSimpleName());
                    pstmt.setString(2, this.sqlName.getSchema());
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        String parentTypeName = rst.getString(1);
                        String parentOwnerName = rst.getString(2);
                        String childTypeName = rst.getString(3);
                        int attrNumber = rst.getInt(4);
                        String childOwnerName = rst.getString(5);
                        if (childOwnerName == null) {
                            childOwnerName = "SYS";
                        }
                        if (parentTypeName.length() <= 0) continue;
                        SQLName parentSQLName = new SQLName(parentOwnerName, parentTypeName, this.connection);
                        TypeTreeElement node = null;
                        if (nodeMap.containsKey(parentSQLName)) {
                            node = (TypeTreeElement)nodeMap.get(parentSQLName);
                        } else {
                            node = new TypeTreeElement(parentOwnerName, parentTypeName);
                            nodeMap.put(parentSQLName, node);
                        }
                        node.putChild(childOwnerName, childTypeName, attrNumber);
                    }
                    if (rst == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rst != null) {
                        rst.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    this.connection.endNonRequestCalls();
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$29, Level.FINEST, OracleNamedType.class, $$$methodRef$$$29, this, throwable2);
                    }
                    throw throwable2;
                }
                rst.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
            this.connection.endNonRequestCalls();
            HashMap<SQLName, TypeTreeElement> hashMap = nodeMap;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleNamedType.class, $$$methodRef$$$29, this, hashMap);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleNamedType.class, $$$methodRef$$$29, this, null);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleNamedType.class, $$$methodRef$$$29, this, throwable3);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleNamedType.class, $$$methodRef$$$30, this, new Object[0]);
            }
            OracleConnection oracleConnection = this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OracleNamedType.class, $$$methodRef$$$30, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleNamedType.class, $$$methodRef$$$30, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleNamedType.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$33 = OracleNamedType.class.getDeclaredConstructor(OracleTypeADT.class, Integer.TYPE, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleNamedType.class.getDeclaredConstructor(String.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleNamedType.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleNamedType.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleNamedType.class.getDeclaredMethod("getNodeMapFromAllTypes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleNamedType.class.getDeclaredMethod("getNodeMapFromUserTypes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleNamedType.class.getDeclaredMethod("getSqlHint", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleNamedType.class.getDeclaredMethod("createTypesTreeMap", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleNamedType.class.getDeclaredMethod("setSqlName", SQLName.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleNamedType.class.getDeclaredMethod("setNames", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleNamedType.class.getDeclaredMethod("initNamesRecursively", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleNamedType.class.getDeclaredMethod("printXML", PrintWriter.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleNamedType.class.getDeclaredMethod("printXML", PrintWriter.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleNamedType.class.getDeclaredMethod("fixupConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleNamedType.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleNamedType.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleNamedType.class.getDeclaredMethod("getTypeVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleNamedType.class.getDeclaredMethod("setDescriptor", TypeDescriptor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleNamedType.class.getDeclaredMethod("getDescriptor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleNamedType.class.getDeclaredMethod("linearize", Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleNamedType.class.getDeclaredMethod("unlinearize", byte[].class, Long.TYPE, Datum.class, Long.TYPE, Integer.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleNamedType.class.getDeclaredMethod("unlinearize", byte[].class, Long.TYPE, Datum.class, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleNamedType.class.getDeclaredMethod("setConnectionInternal", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleNamedType.class.getDeclaredMethod("setConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleNamedType.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleNamedType.class.getDeclaredMethod("setOrder", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleNamedType.class.getDeclaredMethod("getOrder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleNamedType.class.getDeclaredMethod("setParent", OracleTypeADT.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleNamedType.class.getDeclaredMethod("getParent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleNamedType.class.getDeclaredMethod("hasName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleNamedType.class.getDeclaredMethod("getSimpleName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleNamedType.class.getDeclaredMethod("getSchemaName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleNamedType.class.getDeclaredMethod("getFullName", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleNamedType.class.getDeclaredMethod("getFullName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        getUserTypeTreeSql = "select level depth, parent_type, child_type, ATTR_NO, child_type_owner from  (select TYPE_NAME parent_type, ELEM_TYPE_NAME child_type, 0 ATTR_NO,       ELEM_TYPE_OWNER child_type_owner     from USER_COLL_TYPES  union   select TYPE_NAME parent_type, ATTR_TYPE_NAME child_type, ATTR_NO,       ATTR_TYPE_OWNER child_type_owner     from USER_TYPE_ATTRS  ) start with parent_type  = ?  connect by prior  child_type = parent_type";
        getAllTypeTreeSql = "select parent_type, parent_type_owner, child_type, ATTR_NO, child_type_owner from ( select TYPE_NAME parent_type,  OWNER parent_type_owner,     ELEM_TYPE_NAME child_type, 0 ATTR_NO,     ELEM_TYPE_OWNER child_type_owner   from ALL_COLL_TYPES union   select TYPE_NAME parent_type, OWNER parent_type_owner,     ATTR_TYPE_NAME child_type, ATTR_NO,     ATTR_TYPE_OWNER child_type_owner   from ALL_TYPE_ATTRS ) start with parent_type  = ?  and parent_type_owner = ? connect by prior child_type = parent_type   and ( child_type_owner = parent_type_owner or child_type_owner is null )";
    }
}

