/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.module;

import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import java.util.Set;

public class ResolveSourceImportNode
extends StatementNode {
    private final JSContext context;
    private final Module.ModuleRequest moduleRequest;
    @Node.Child
    private JavaScriptNode moduleNode;
    @Node.Child
    private JSWriteFrameSlotNode writeLocalNode;

    ResolveSourceImportNode(JSContext context, JavaScriptNode moduleNode, Module.ModuleRequest moduleRequest, JSWriteFrameSlotNode writeLocalNode) {
        this.context = context;
        this.moduleRequest = moduleRequest;
        this.moduleNode = moduleNode;
        this.writeLocalNode = writeLocalNode;
    }

    @NeverDefault
    public static StatementNode create(JSContext context, JavaScriptNode moduleNode, Module.ModuleRequest moduleRequest, JSWriteFrameSlotNode writeLocalNode) {
        return new ResolveSourceImportNode(context, moduleNode, moduleRequest, writeLocalNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        JSModuleRecord referencingScriptOrModule = (JSModuleRecord)this.moduleNode.execute(frame);
        AbstractModuleRecord importedModule = referencingScriptOrModule.getImportedModule(this.moduleRequest);
        Object moduleSourceObject = importedModule.getModuleSource();
        this.writeLocalNode.executeWrite(frame, moduleSourceObject);
        return EMPTY;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return ResolveSourceImportNode.create(this.context, ResolveSourceImportNode.cloneUninitialized(this.moduleNode, materializedTags), this.moduleRequest, ResolveSourceImportNode.cloneUninitialized(this.writeLocalNode, materializedTags));
    }
}

