﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/medialive/MediaLive_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MediaLive {
namespace Model {

/**
 * Input Location<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputLocation">AWS
 * API Reference</a></p>
 */
class InputLocation {
 public:
  AWS_MEDIALIVE_API InputLocation() = default;
  AWS_MEDIALIVE_API InputLocation(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIALIVE_API InputLocation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIALIVE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * key used to extract the password from EC2 Parameter store
   */
  inline const Aws::String& GetPasswordParam() const { return m_passwordParam; }
  inline bool PasswordParamHasBeenSet() const { return m_passwordParamHasBeenSet; }
  template <typename PasswordParamT = Aws::String>
  void SetPasswordParam(PasswordParamT&& value) {
    m_passwordParamHasBeenSet = true;
    m_passwordParam = std::forward<PasswordParamT>(value);
  }
  template <typename PasswordParamT = Aws::String>
  InputLocation& WithPasswordParam(PasswordParamT&& value) {
    SetPasswordParam(std::forward<PasswordParamT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * Uniform Resource Identifier - This should be a path to a file accessible to the
   * Live system (eg. a http:// URI) depending on the output type. For example, a
   * RTMP destination should have a uri simliar to: "rtmp://fmsserver/live".
   */
  inline const Aws::String& GetUri() const { return m_uri; }
  inline bool UriHasBeenSet() const { return m_uriHasBeenSet; }
  template <typename UriT = Aws::String>
  void SetUri(UriT&& value) {
    m_uriHasBeenSet = true;
    m_uri = std::forward<UriT>(value);
  }
  template <typename UriT = Aws::String>
  InputLocation& WithUri(UriT&& value) {
    SetUri(std::forward<UriT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * Documentation update needed
   */
  inline const Aws::String& GetUsername() const { return m_username; }
  inline bool UsernameHasBeenSet() const { return m_usernameHasBeenSet; }
  template <typename UsernameT = Aws::String>
  void SetUsername(UsernameT&& value) {
    m_usernameHasBeenSet = true;
    m_username = std::forward<UsernameT>(value);
  }
  template <typename UsernameT = Aws::String>
  InputLocation& WithUsername(UsernameT&& value) {
    SetUsername(std::forward<UsernameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_passwordParam;
  bool m_passwordParamHasBeenSet = false;

  Aws::String m_uri;
  bool m_uriHasBeenSet = false;

  Aws::String m_username;
  bool m_usernameHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaLive
}  // namespace Aws
