/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class FileStoreStructureProvider
implements IImportStructureProvider {
    public static final FileStoreStructureProvider INSTANCE = new FileStoreStructureProvider();

    @Override
    public List getChildren(Object element) {
        try {
            return Arrays.asList(((IFileStore)element).childStores(0, (IProgressMonitor)new NullProgressMonitor()));
        }
        catch (CoreException exception) {
            this.logException(exception);
            return new ArrayList();
        }
    }

    private void logException(CoreException exception) {
        IDEWorkbenchPlugin.log(exception.getLocalizedMessage(), exception);
    }

    @Override
    public InputStream getContents(Object element) {
        try {
            return ((IFileStore)element).openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException exception) {
            this.logException(exception);
            return null;
        }
    }

    @Override
    public String getFullPath(Object element) {
        return ((IFileStore)element).toURI().getSchemeSpecificPart();
    }

    @Override
    public String getLabel(Object element) {
        return ((IFileStore)element).getName();
    }

    @Override
    public boolean isFolder(Object element) {
        return ((IFileStore)element).fetchInfo().isDirectory();
    }
}

