# frozen_string_literal: true

module WebIde
  module Settings
    class DefaultSettings
      # ALL WEB IDE SETTINGS ARE DECLARED HERE.
      # @return [Hash]
      def self.default_settings
        {
          vscode_extension_marketplace: [
            {}, # NOTE: There is no default, the value is always generated by ExtensionMarketplaceGenerator
            Hash
          ],
          vscode_extension_marketplace_metadata: [
            { enabled: false, disabled_reason: :instance_disabled },
            Hash
          ],
          vscode_extension_marketplace_home_url: [
            "",
            String
          ],
          vscode_extension_marketplace_view_model: [
            { enabled: false, reason: :instance_disabled, help_url: '' },
            Hash
          ]
        }
      end
    end
  end
end
