---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 認証と認可の用語集
description: 認証、認可、アクセス許可、ロール、およびアクセス制御の用語。
---

この用語集では、GitLabの認証、認可、およびアクセス制御に関連する用語を定義します。これらの概念を理解することで、安全なアクセスを構成し、アクセス許可を効果的に管理できます。

## アクセス制御 {#access-control}

（ユーザーの身元を確認する）認証と（ユーザーが何ができるかを判断する）認可に基づいて、リソースへのアクセスを制限すること。アクセス制御を使用して、機密情報と機能を保護します。

## アクセスレベル {#access-level}

新しいユーザーを作成するときに割り当てる許可レベル。アクセスレベルには、[Regular]、[監査担当者]、および[管理者]が含まれます。アクセスレベルは、ロールおよびアクセス許可とは異なります。

## 管理者 {#administrator}

システムアクセスレベルが最も高いユーザーで、インスタンス全体の設定を構成したり、他のユーザーを管理したり、すべてのグループおよびプロジェクトにわたって管理タスクを実行したりできます。

<!--For more information, see [administrator users](../auth/users_admin.md). -->
## 監査担当者 {#auditor}

すべてのグループ、プロジェクト、および管理機能への読み取り専用アクセス権を持つ特別なユーザータイプ。監査担当者は変更を加えることはできませんが、コンプライアンスとセキュリティのためにコンテンツを表示できます。

詳細については、[監査担当者ユーザー](../administration/auditor_users.md)を参照してください。

## 認証 {#authentication}

GitLabへのアクセスを許可する前に、ユーザーの身元を確認するプロセス。認証方式には、パスワード、2要素認証、SSHキー、パーソナルアクセストークン、および外部アイデンティティプロバイダーとのインテグレーションが含まれます。

詳細については、[ユーザー認証](user_authentication.md)を参照してください。

## 認証 {#authorization}

認証済みユーザーがGitLabで実行できるアクションを決定するプロセス。認可は、ユーザーに割り当てられたロール、アクセス許可、およびグループとプロジェクトのメンバーシップに基づいています。

## 境界 {#boundaries}

アクセス許可とポリシーを適用できる組織レベル:

- インスタンス: GitLabデプロイ全体に適用
- グループ: 特定のグループとそのサブグループまたはプロジェクトに適用
- プロジェクト: 単一のプロジェクトにのみ適用
- ユーザー: 特定のユーザーによって、またはそのユーザーの代わりに実行されるアクションに適用

## カスタムロール {#custom-roles}

組織のニーズに合わせて調整された特定のアクセス許可を持つユーザー定義のロール。カスタムロールを使用して、GitLabが提供するデフォルトロールに一致しないアクセス許可セットを作成します。

詳細については、[カスタムロール](../user/custom_roles/_index.md)を参照してください。

## デフォルトロール {#default-roles}

GitLabで利用可能な定義済みのロール: 最小アクセス、ゲスト、プランナー、レポーター、デベロッパー、メンテナー、およびオーナー。各ロールには、特定のアクセス許可セットが含まれています。

詳細については、[ロールとアクセス許可](../user/permissions.md)を参照してください。

## 外部ユーザー {#external-users}

組織の外部として指定され、内部プロジェクトおよびグループへのアクセスが制限されているユーザー。外部ユーザーは、明示的なメンバーシップを持つプロジェクトにのみアクセスできます。

詳細については、[外部ユーザー](../administration/external_users.md)を参照してください。

## グループ {#group}

効率的な組織とアクセス許可管理を可能にする、関連するプロジェクトとユーザーのコレクション。グループにはサブグループを含めることができ、親グループからアクセス許可を継承できます。

## 継承 {#inheritance}

親グループから子グループおよびプロジェクトへのアクセス許可の自動フロー。継承は、より高いレベルで付与されたアクセス許可を下のすべてのネストされたコンテンツに適用することで、アクセスの管理を簡素化します。

## メンバー {#member}

特定のグループまたはプロジェクトへのアクセスを許可されたユーザー。メンバーには、そのリソースでのアクセス許可を決定する割り当てられたロールがあります。

<!-- For more information, see [group and project membership](../auth/membership.md). -->
## メンバーシップ {#membership}

ユーザーと特定のグループまたはプロジェクト間の関連付け。それらのリソースでのアクセス権を定義します。ユーザーは、複数のグループとプロジェクトにわたって異なるメンバーシップとロールを持つことができます。

## 権限 {#permissions}

ユーザーがGitLabリソースで実行できる特定のアクション。アクセス許可はロールに組み合わされ、イシューの作成、プッシュ、またはプロジェクトの設定の管理などのアクションが含まれます。

詳細については、[ロールとアクセス許可](../user/permissions.md)を参照してください。

## パーソナルアクセストークン {#personal-access-token}

GitLabまたはHTTPS経由のGitを使用する場合の認証のパスワードの代替として機能するトークン。パーソナルアクセストークンには、実行できるアクションを制限する定義されたスコープがあります。

詳細については、[パーソナルアクセストークン](../user/profile/personal_access_tokens.md)を参照してください。

## リソース {#resources}

プロジェクト、グループ、イシュー、マージリクエスト、スニペット、パイプライン、およびマイルストーンなど、GitLabで管理または操作できるオブジェクト。

## ロール {#roles}

グループおよびプロジェクトで実行できるアクションを決定する、ユーザーに割り当てられた定義済みのまたはカスタムロールのアクセス許可セット。ロールには、デフォルトロールとカスタムロールの両方が含まれます。

詳細については、[ロールとアクセス許可](../user/permissions.md)を参照してください。

## スコープ {#scopes}

パーソナルアクセストークン、グループアクセストークン、プロジェクトアクセストークン、およびOAuthアプリケーションで利用できるリソースとアクセス許可を定義する広範な境界。

スコープには、トークンのタイプまたはスコープが適用される場所に応じて、リソース、アクセス許可、またはその両方の任意の組み合わせを含めることができます。たとえば、パーソナルアクセストークンにはアクセス許可のみが含まれますが、ジョブトークンにはアクセス許可とリソースの両方が含まれます。

## サービスアカウント {#service-accounts}

自動化されたアクションを実行したり、データにアクセスしたり、スケジュールされたプロセスを実行したりするように設計された、人間以外のユーザーアカウント。サービスアカウントは通常、パスワードの代わりに認証にトークンを使用します。

## SSHキー {#ssh-keys}

Gitリポジトリへのアクセス時に安全な認証に使用される暗号キー。SSHキーは、Git操作に対してパスワードベースの認証に代わる安全な手段を提供します。

詳細については、[SSHキー](../user/ssh.md)を参照してください。

## 2要素認証（2FA） {#two-factor-authentication-2fa}

パスワードに加えて、2番目の形式の認証を提供するようにユーザーに要求する追加のセキュリティレイヤー。GitLabは、認証アプリやリカバリーなど、さまざまな2要素認証方式をサポートしています。

詳細については、[2要素認証](../user/profile/account/two_factor_authentication.md)を参照してください。

## ユーザーアカウント {#user-account}

GitLabにアクセスする人を表す個人のアカウント。ユーザーアカウントにはアクセスレベルがあり、さまざまなグループとプロジェクトにわたってさまざまなロールを割り当てることができます。

## 表示レベル {#visibility}

コンテンツを表示およびアクセスできるユーザーを制御する設定:

- パブリック: GitLabアカウントを持たないユーザーを含む、すべての人に表示
- 内部: すべての認証済みGitLabユーザーに表示
- プライベート: メンバーのみに制限
