---
stage: Software Supply Chain Security
group: Compliance
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: トップレベルグループの監査イベントストリーミング
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- [サブグループイベントの記録](https://gitlab.com/gitlab-org/gitlab/-/issues/366878)は、GitLab 15.2で修正されました。
- カスタムHTTPヘッダーUIがGitLab 15.2で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/361630)され、`custom_headers_streaming_audit_events_ui`という[フラグ付き](../../administration/feature_flags/list.md)で提供されました。デフォルトでは無効になっています。
- カスタムHTTPヘッダーUIは、GitLab 15.3で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/365259)されました。[機能フラグ`custom_headers_streaming_audit_events_ui`](https://gitlab.com/gitlab-org/gitlab/-/issues/365259)は削除されました。
- GitLab 15.3で[ユーザーエクスペリエンスが向上](https://gitlab.com/gitlab-org/gitlab/-/issues/367963)。
- HTTPの送信先**名前**フィールドがGitLab 16.3で[追加](https://gitlab.com/gitlab-org/gitlab/-/issues/411357)されました。
- GitLab 16.5で、**アクティブ**チェックボックスの機能が[追加](https://gitlab.com/gitlab-org/gitlab/-/issues/415268)されました。

{{< /history >}}

トップレベルグループの監査イベントストリーミングにより、グループオーナーは次のことが可能になります:

- トップレベルグループのストリーミング先を設定して、グループ、サブグループ、プロジェクトに関するすべての監査イベントを構造化されたJSONとして受信できます。
- サードパーティシステムで監査ログを管理します。構造化されたJSONデータを受信できるサービスは、ストリーミング先として使用できます。

各ストリーミング先:

- ストリーミングされるイベントごとに、最大20個のカスタムHTTPヘッダーを含めることができます。
- GitLab.comの場合、[GitLab.com IPアドレス範囲](../gitlab_com/_index.md#ip-range)からのトラフィックを許可する必要があります。

GitLabは、単一のイベントを同じ送信先に複数回ストリーミングできます。ペイロードの`id`キーを使用して、受信データを重複排除します。

監査イベントは、HTTPでサポートされているPOSTリクエストメソッドプロトコルを使用して送信されます。

{{< alert type="warning" >}}

ストリーミング先は、すべての監査イベントデータを受信します。これには機密情報が含まれる可能性があります。信頼できるストリーミング先であることを確認してください。ストリーミング先を信頼できることを確認してください。

{{< /alert >}}

## HTTPの送信先 {#http-destinations}

前提要件: 

- セキュリティを強化するには、宛先URLでSSL証明書を使用する必要があります。

トップレベルグループのHTTPストリーミング先を管理します。

### 新しいHTTPの送信先を追加 {#add-a-new-http-destination}

トップレベルグループに新しいHTTPストリーミング先を追加します。

前提要件: 

- トップレベルグループのオーナーロール。

トップレベルグループにストリーミング先を追加するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. **ストリーム先を追加**を選択し、**HTTPエンドポイント**を選択して、送信先を追加するためのセクションを表示します。
1. **名前**フィールドと**宛先URL**フィールドに、送信先の名前とURLを追加します。
1. オプション。**Custom HTTP headers**（カスタムHTTPヘッダー）テーブルを探します。
1. ヘッダーを有効にするには、**アクティブ**チェックボックスをオンにします。ヘッダーは監査イベントとともに送信されます。
1. **ヘッダーを追加**を選択して、新しい名前と値のペアを作成します。必要な名前と値のペアの数だけ入力します。ストリーミング先ごとに最大20個のヘッダーを追加できます。
1. すべてのヘッダーを入力したら、**追加**を選択して、新しいストリーミング先を追加します。

### HTTPの送信先を更新 {#update-an-http-destination}

前提要件: 

- グループのオーナーロール。

ストリーミング先の名前を更新するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. 展開するストリームを選択します。
1. **名前**フィールドで、更新する宛先名を追加します。
1. **保存**を選択して、ストリーミング先を更新します。

トップレベルグループのストリーミング先のカスタムHTTPヘッダーを更新するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. 展開するストリームを選択します。
1. **Custom HTTP headers**（カスタムHTTPヘッダー）テーブルを探します。
1. 更新するヘッダーを探します。
1. ヘッダーを有効にするには、**アクティブ**チェックボックスをオンにします。ヘッダーは監査イベントとともに送信されます。
1. **ヘッダーを追加**を選択して、新しい名前と値のペアを作成します。必要な名前と値のペアの数だけ入力します。ストリーミング先ごとに最大20個のヘッダーを追加できます。
1. **保存**を選択して、ストリーミング先を更新します。

### イベントの信頼性を検証 {#verify-event-authenticity}

{{< history >}}

- GitLab 15.2で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/360814)されました。

{{< /history >}}

各ストリーミング先には、イベントの信頼性を検証するために使用できる一意の検証トークン（`verificationToken`）があります。このトークンはオーナーによって指定されるか、イベントの送信先が作成されたときに自動的に生成され、変更できません。

`verificationToken`パラメータは、[GraphQL API](../../api/graphql/audit_event_streaming_groups.md#add-a-new-streaming-destination)を使用することによってのみ設定できます。

ストリーミングされる各イベントには、ストリーミング先をリストするときに送信先の値に対して検証できる、`X-Gitlab-Event-Streaming-Token` HTTPヘッダーに検証トークンが含まれています。

前提要件: 

- グループのオーナーロール。

ストリーミング先をリストし、トークンの検証トークンを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. 展開するストリームを選択します。
1. **検証トークン**入力を見つけます。

### イベントフィルターを更新 {#update-event-filters}

{{< history >}}

- 定義された監査イベントタイプのリストを使用したUIでのイベントタイプのフィルタリングが、GitLab 16.1で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/413581)されました。

{{< /history >}}

この機能フラグがグループに対して有効になっている場合、ユーザーは送信先ごとにストリーミングされた監査イベントをフィルタリングできます。機能がフィルターなしで有効になっている場合、送信先はすべての監査イベントを受信します。

イベントタイプのフィルターが設定されているストリーミング先には、**フィルタリング済み** ({{< icon name="filter" >}}) ラベルが付きます。

ストリーミング先のイベントフィルターを更新するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. 展開するストリームを選択します。
1. **監査イベントタイプでフィルタリング**でフィルターするドロップダウンリストを探します。
1. ドロップダウンリストを選択し、必要なイベントタイプを選択またはクリアします。
1. **保存**を選択して、イベントフィルターを更新します。

### ネームスペースフィルターを更新 {#update-namespace-filters}

{{< history >}}

- UIのネームスペースフィルタリングは、GitLab 16.7で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/390133)。

{{< /history >}}

この機能フラグがグループに対して有効になっている場合、ユーザーは送信先ごとにストリーミングされた監査イベントをフィルタリングできます。機能がフィルターなしで有効になっている場合、送信先はすべての監査イベントを受信します。

ネームスペースフィルターが設定されているストリーミング先には、**フィルタリング済み** ({{< icon name="filter" >}}) ラベルが付きます。

ストリーミング先のネームスペースフィルターを更新するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. 展開するストリームを選択します。
1. **グループまたはプロジェクトでフィルタリング**ドロップダウンリストを見つけます。
1. ドロップダウンリストを選択し、必要なネームスペースを選択またはクリアします。
1. **保存**を選択して、ネームスペースフィルターを更新します。

### デフォルトのコンテンツタイプのヘッダーをオーバーライド {#override-default-content-type-header}

デフォルトでは、ストリーミング先は`content-type`のヘッダーである`application/x-www-form-urlencoded`を使用します。ただし、`content-type`ヘッダーを他の値に設定することもできます。たとえば`application/json`などです。

トップレベルグループのストリーミング先の`content-type`のデフォルト値をオーバーライドするには、次のいずれかを使用します:

- [GitLab UI](#update-an-http-destination)。
- [GraphQL API](../../api/graphql/audit_event_streaming_groups.md#update-streaming-destinations)を使用します。

## Google Cloud Loggingの送信先 {#google-cloud-logging-destinations}

{{< history >}}

- GitLab 16.2で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/124384)されました。

{{< /history >}}

トップレベルグループのGoogle Cloud Loggingストリーミング先を管理します。

### 前提要件 {#prerequisites}

Google Cloud Loggingの監査イベントのストリーミングを設定する前に、次のことを行う必要があります:

1. Google Cloudプロジェクトで[Cloud Logging API](https://console.cloud.google.com/marketplace/product/google/logging.googleapis.com)を有効にします。
1. 適切な認証情報と権限を持つGoogle Cloudのサービスアカウントを作成します。このアカウントは、監査ログのストリーミング認証を構成するために使用されます。詳細については、[Google Cloudドキュメントでのサービスアカウントの作成と管理](https://cloud.google.com/iam/docs/service-accounts-create#creating)を参照してください。
1. サービスアカウントの**Logs Writer**（ログライター）ロールを有効にして、Google Cloudでログを有効にします。詳細については、[IAMを使用したアクセス制御](https://cloud.google.com/logging/docs/access-control#logging.logWriter)を参照してください。
1. サービスアカウントのJSONキーを作成します。詳細については、[サービスアカウントキーの作成](https://cloud.google.com/iam/docs/keys-create-delete#creating)を参照してください。

### 新しいGoogle Cloud Loggingの送信先を追加 {#add-a-new-google-cloud-logging-destination}

前提要件: 

- トップレベルグループのオーナーロール。

トップレベルグループにGoogle Cloud Loggingのストリーミング先を追加するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. **ストリーム先を追加**を選択し、**Google Cloud Logging**を選択して、送信先を追加するためのセクションを表示します。
1. 新しい送信先の名前として使用するランダムな文字列を入力します。
1. 新しストリーミング先を追加するには、以前に作成したGoogle Cloudサービスアカウントキーから、GoogleプロジェクトID、Googleクライアントメール、Googleプライベートキーを入力します。
1. 新しい送信先のログIDとして使用するランダムな文字列を入力します。これは、後でGoogle Cloudでログの結果をフィルターするために使用できます。
1. **追加**を選択して、新しいストリーミング先を追加します。

### Google Cloud Loggingの送信先を更新 {#update-a-google-cloud-logging-destination}

{{< history >}}

- プライベートキーを追加するボタンは、GitLab 16.3で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/419675)。

{{< /history >}}

前提要件: 

- トップレベルグループのオーナーロール。

トップレベルグループのGoogle Cloud Loggingのストリーミング先を更新するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. 展開するGoogle Cloud Loggingストリームを選択します。
1. 送信先の名前として使用するランダムな文字列を入力します。
1. 以前に作成したGoogle CloudサービスアカウントキーからGoogleプロジェクトIDとGoogleクライアントメールを入力して、送信先を更新します。
1. 送信先のログIDを更新するランダムな文字列を入力します。これは、後でGoogle Cloudでログの結果をフィルターするために使用できます。
1. **新しい秘密キーを追加**を選択し、Googleの秘密キーを入力して、秘密キーを更新します。
1. **保存**を選択して、ストリーミング先を更新します。

## AWS S3の送信先 {#aws-s3-destinations}

{{< history >}}

- GitLab 16.6で`allow_streaming_audit_events_to_amazon_s3`[フラグ](../../administration/feature_flags/list.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132603)されました。デフォルトでは有効になっています。
- [機能フラグ`allow_streaming_audit_events_to_amazon_s3`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137391)は、GitLab 16.7で削除されました。

{{< /history >}}

トップレベルグループのAWS S3ストリーミング先を管理します。

### 前提要件 {#prerequisites-1}

AWS S3の監査イベントのストリーミングを設定する前に、次のことを行う必要があります:

1. 適切な認証情報と権限を持つAWSのアクセスキーを作成します。このアカウントは、監査ログのストリーミング認証を構成するために使用されます。詳細については、[アクセスキーの管理](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html?icmpid=docs_iam_console#Using_CreateAccessKey)を参照してください。
1. AWS S3バケットを作成します。このバケットは、監査ログのストリーミングデータを保存するために使用されます。詳細については、[バケットの作成](https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-bucket-overview.html)を参照してください

### 新しいAWS S3の送信先を追加 {#add-a-new-aws-s3-destination}

前提要件: 

- トップレベルグループのオーナーロール。

トップレベルグループにAWS S3ストリーミング先を追加するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. **ストリーム先を追加**を選択し、**AWS S3**を選択して、送信先を追加するためのセクションを表示します。
1. 新しい送信先の名前として使用するランダムな文字列を入力します。
1. 以前に作成したAWSのアクセスキーとバケットから、**アクセスキーID**、**シークレットアクセスキー**、**バケット名**、**AWSリージョン**を入力して、新しい送信先に追加します。
1. **追加**を選択して、新しいストリーミング先を追加します。

### AWS S3の送信先を更新 {#update-an-aws-s3-destination}

前提要件: 

- トップレベルグループのオーナーロール。

トップレベルグループへのAWS S3ストリーミング先を更新するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. 展開するAWS S3ストリームを選択します。
1. 送信先の名前として使用するランダムな文字列を入力します。
1. 送信先を更新するには、以前に作成したAWSのアクセスキーとバケットから、**アクセスキーID**、**シークレットアクセスキー**、**バケット名**、**AWSリージョン**を入力します。
1. **Add a new Secret Access Key**（新しいシークレットアクセスキーを追加）を選択し、AWSのシークレットアクセスキーを入力して、シークレットアクセスキーを更新します。
1. **保存**を選択します。

## ストリーミング先をリスト {#list-streaming-destinations}

前提要件: 

- トップレベルグループのオーナーロール。

トップレベルグループのストリーミング先をリストするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. 展開するストリームを選択します。

## ストリーミング先を有効または無効にする {#activate-or-deactivate-streaming-destinations}

{{< history >}}

- GitLab 18.2で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/537096)されました。

{{< /history >}}

送信先の構成を削除せずに、送信先への監査イベントのストリーミングを一時的に無効にすることができます。ストリーミング先が無効になっている場合:

- ストリーミング先への監査イベントのストリーミングがただちに停止します。
- ストリーミング先設定は保持されます。
- いつでもストリーミング先を再度アクティブにできます。
- 他のアクティブなストリーミング先は、引き続きイベントを受信します。

### ストリーミング先を非アクティブにする {#deactivate-a-streaming-destination}

前提要件: 

- トップレベルグループのオーナーロール。

ストリーミング先を非アクティブにするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. 展開するストリームを選択します。
1. **アクティブ**チェックボックスをオフにします。
1. **保存**を選択します。

ストリーミング先は監査イベントの受信を停止します。

### ストリーミング先をアクティブにする {#activate-a-streaming-destination}

以前に非アクティブ化されたストリーミング先を再度アクティブにするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. 展開するストリームを選択します。
1. **アクティブ**チェックボックスを選択します。
1. **保存**を選択します。

ストリーミング先は、監査イベントの受信をただちに再開します。

## ストリーミング先を削除する {#delete-streaming-destinations}

トップレベルグループのストリーミング先を削除します。最後のストリーミング先が正常に削除されると、トップレベルグループのストリーミングは無効になります。

前提要件: 

- トップレベルグループのオーナーロール。

トップレベルグループのストリーミング先を削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. 展開するストリームを選択します。
1. **移動先を削除**を選択します。
1. 確認するには、**移動先を削除**を選択します。

### カスタムHTTPヘッダーのみを削除する {#delete-only-custom-http-headers}

前提要件: 

- トップレベルグループのオーナーロール。

ストリーミング先のカスタムHTTPヘッダーのみを削除するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオンにしている](../interface_redesign.md#turn-new-navigation-on-or-off)場合、このフィールドは上部のバーにあります。
1. **セキュリティ** > **監査イベント**を選択します。
1. メイン領域で、**ストリーム**タブを選択します。
1. 展開するストリームを選択します。
1. **Custom HTTP headers**（カスタムHTTPヘッダー）テーブルを探します。
1. 削除するヘッダーを探します。
1. ヘッダーの右側にある**削除** ({{< icon name="remove" >}})を選択します。
1. **保存**を選択します。

## 関連トピック {#related-topics}

- [インスタンスの監査イベントストリーミング](../../administration/compliance/audit_event_streaming.md)
