---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 情報を公開せずに、機密イシューのマージリクエストを作成する方法。
title: 機密イシューのマージリクエスト
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

パブリックリポジトリ内のマージリクエストは、[機密イシュー](../issues/confidential_issues.md)のマージリクエストを作成する場合でも、公開されます。機密イシューに取り組む際に機密情報が漏洩しないようにするには、同じネームスペース内のプライベートなフォークからマージリクエストを作成します。

ロールは親グループから継承されます。元の（パブリック）リポジトリと同じネームスペース（同じグループまたはサブグループ）にプライベートなフォークを作成すると、デベロッパーはフォークで同じ権限を受け取ります。この継承により、以下が保証されます:

- デベロッパーユーザーは、機密イシューを表示し、解決するために必要な権限を持っています。
- フォークへのアクセスを個々のユーザーに許可する必要はありません。

詳細については、[GitLabエンジニア向けパッチリリース手順書をご覧ください: パッチリリースのセキュリティ修正の準備](https://gitlab.com/gitlab-org/release/docs/blob/master/general/security/engineer.md)。

## 機密マージリクエストを作成します {#create-a-confidential-merge-request}

ブランチはデフォルトでパブリックです。作業の機密性を保護するには、同じネームスペースにブランチとマージリクエストを作成する必要がありますが、プライベートなフォークのダウンストリームに作成する必要があります。パブリックリポジトリと同じネームスペースにプライベートなフォークを作成すると、フォークはアップストリームパブリックリポジトリの権限を継承します。アップストリームパブリックリポジトリのデベロッパーロールを持つユーザーは、お客様の操作なしに、ダウンストリームのプライベートなフォークでそれらのアップストリーム権限を継承します。これらのユーザーは、機密イシューの修正を支援するために、プライベートなフォークのブランチにすぐにプッシュできます。

{{< alert type="warning" >}}

アップストリームリポジトリとは異なるネームスペースに作成すると、プライベートなフォークから機密情報が漏洩する可能性があります。2つのネームスペースに同じユーザーが含まれていない可能性があります。

{{< /alert >}}

前提要件: 

- パブリックリポジトリのオーナーまたはメンテナーロールが必要です。これは、[サブグループを作成](../../group/subgroups/_index.md)するために、これらのロールのいずれかが必要であるためです。
- パブリックリポジトリを[フォーク](../repository/forking_workflow.md)しました。
- フォークの**表示レベル**は**プライベート**です。

機密マージリクエストを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**Plan** > **イシュー**を選択し、マージリクエストを作成するイシューを見つけます。
1. イシューの説明の下までスクロールし、**非公開のマージリクエストを作成する**を選択します。
1. ニーズに合った項目を選択します:
   - ブランチとマージリクエストの両方を作成するには、**非公開のマージリクエストとブランチを作成する**を選択します。マージリクエストは、パブリックのアップストリームプロジェクトのデフォルトブランチではなく、フォークのデフォルトブランチをターゲットにします。
   - ブランチのみを作成するには、**ブランチを作成**を選択します。
1. 使用する**プロジェクト**を選択します。これらのプロジェクトではマージリクエストが有効になっており、デベロッパーロール（またはそれ以上）が付与されています。
1. **ブランチ名**を入力し、**ソース (ブランチまたはタグ)**を選択します。両方のブランチが選択したフォークで使用可能である必要があるため、GitLabはこれらのブランチがプライベートなフォークで使用可能かどうかを確認します。
1. **作成**を選択します。

このマージリクエストは、パブリックのアップストリームプロジェクトではなく、プライベートなフォークをターゲットにしています。ブランチ、マージリクエスト、およびコミットは、プライベートなフォークに残ります。これにより、機密情報の早期公開を防ぎます。

問題がプライベートなフォークで解決されたと思われる場合、[フォークからアップストリームリポジトリに](../repository/forking_workflow.md#merge-changes-back-upstream)マージリクエストを開きます:

- 問題がプライベートなフォークで解決されたと思われる場合。
- 機密のコミットを公開する準備ができている。

## 関連トピック {#related-topics}

- [非公開イシュー](../issues/confidential_issues.md)
- [エピックを非公開にする](../../group/epics/manage_epics.md#make-an-epic-confidential)
- [内部メモを追加する](../../discussions/_index.md#add-an-internal-note)
- GitLabでの[機密マージリクエストのセキュリティプラクティス](https://gitlab.com/gitlab-org/release/docs/blob/master/general/security/engineer.md#security-releases-critical-non-critical-as-a-developer)
