# frozen_string_literal: true

module Gitlab
  module BackgroundMigration
    class RemoveOrphanedVulnerabilityNotesBatchedMigration < BatchedMigrationJob
      operation_name :remove_orphaned_vulnerability_notes
      feature_category :vulnerability_management

      def perform
        each_sub_batch do |sub_batch|
          orphaned_notes = sub_batch
            .where(noteable_type: 'Vulnerability')
            .where.not(noteable_id: Vulnerability.where(id: sub_batch.pluck(:noteable_id)).pluck(:id)) # rubocop:disable Rails/PluckInWhere -- we want to use pluck here
          orphaned_notes.delete_all
        end
      end
    end
  end
end
