/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.function.filesleuth.FindFilesFunction;

public class StartFindFilesFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private JTextField _searchDirBox = null;
    private JCheckBox _subdirsCheckbox = null;
    private JButton _okButton = null;

    public StartFindFilesFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "menu.file.findfile";
    }

    @Override
    public void begin() {
        String string;
        if (this._dialog == null) {
            this._dialog = new JDialog((Frame)this._parentFrame, this.getName());
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeContents());
            this._dialog.pack();
        }
        this._searchDirBox.setText((string = this.getConfig().getConfigString("prune.trackdirectory")) == null ? "" : string);
        this.enableButtons();
        this._dialog.setVisible(true);
    }

    private void enableButtons() {
        String string = this._searchDirBox.getText();
        boolean bl = false;
        if (!string.equals("")) {
            File file = new File(string);
            bl = file.exists() && file.canRead() && file.isDirectory();
        }
        this._okButton.setEnabled(bl);
    }

    private Component makeContents() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        jPanel.setLayout(new BorderLayout(0, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel(String.valueOf(I18nManager.getText("dialog.findfile.dir")) + " : "), "West");
        this._searchDirBox = new JTextField(24);
        this._searchDirBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                StartFindFilesFunction.this.enableButtons();
            }
        });
        this._searchDirBox.addActionListener(actionEvent -> this.finish());
        jPanel2.add((Component)this._searchDirBox, "Center");
        JButton jButton = new JButton(I18nManager.getText("button.browse"));
        jButton.addActionListener(actionEvent -> this.chooseDir());
        jPanel2.add((Component)jButton, "East");
        this._subdirsCheckbox = new JCheckBox(I18nManager.getText("dialog.open.includesubdirectories"), true);
        jPanel2.add((Component)this._subdirsCheckbox, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(actionEvent -> this.finish());
        jPanel4.add(this._okButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel4.add(jButton2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jPanel4, "East");
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    private void chooseDir() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        String string = this._searchDirBox.getText();
        if (string.length() > 1) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        if (jFileChooser.showOpenDialog(this._parentFrame) == 0) {
            this._searchDirBox.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
        this.enableButtons();
    }

    private void finish() {
        if (!this._okButton.isEnabled()) {
            return;
        }
        File file = new File(this._searchDirBox.getText());
        if (this.hasAnyFiles(file, this._subdirsCheckbox.isSelected())) {
            new FindFilesFunction(this._app, file, this._subdirsCheckbox.isSelected()).begin();
            this._dialog.dispose();
        } else {
            this._app.showErrorMessage(this.getNameKey(), "error.findfile.nofilesfound");
        }
    }

    private boolean hasAnyFiles(File file, boolean bl) {
        File file2;
        if (!(file != null && file.exists() && file.canRead() && file.isDirectory())) {
            return false;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return false;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            file2 = fileArray2[n2];
            if (file2 != null && file2.isFile() && file2.canRead()) {
                return true;
            }
            ++n2;
        }
        if (bl) {
            fileArray2 = fileArray;
            n = fileArray.length;
            n2 = 0;
            while (n2 < n) {
                file2 = fileArray2[n2];
                if (file2 != null && file2.isDirectory() && file2.canRead() && this.hasAnyFiles(file2, true)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

