/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core;

import java.io.Closeable;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import tools.jackson.core.JsonParser;
import tools.jackson.core.TokenStreamLocation;

public class JacksonException
extends RuntimeException {
    private static final long serialVersionUID = 3L;
    private static final int MAX_REFS_TO_LIST = 500;
    protected TokenStreamLocation _location;
    protected LinkedList<Reference> _path;
    protected transient Closeable _processor;

    protected JacksonException(String msg) {
        super(msg);
    }

    protected JacksonException(Throwable rootCause) {
        super(rootCause);
    }

    protected JacksonException(String msg, Throwable rootCause) {
        this(null, msg, null, rootCause);
    }

    protected JacksonException(String msg, TokenStreamLocation loc, Throwable rootCause) {
        this(null, msg, loc, rootCause);
    }

    protected JacksonException(Closeable processor, Throwable rootCause) {
        super(rootCause);
        this._processor = processor;
        this._location = JacksonException._nonNullLocation(null);
    }

    protected JacksonException(Closeable processor, String msg, TokenStreamLocation loc, Throwable rootCause) {
        super(msg, rootCause);
        this._processor = processor;
        this._location = JacksonException._nonNullLocation(loc);
    }

    protected JacksonException(Closeable processor, String msg) {
        super(msg);
        this._processor = processor;
        TokenStreamLocation loc = null;
        if (processor instanceof JsonParser) {
            loc = ((JsonParser)processor).currentTokenLocation();
        }
        this._location = JacksonException._nonNullLocation(loc);
    }

    protected JacksonException(Closeable processor, String msg, Throwable problem) {
        super(msg, problem);
        this._processor = processor;
        TokenStreamLocation loc = null;
        if (problem instanceof JacksonException) {
            loc = ((JacksonException)problem).getLocation();
        } else if (processor instanceof JsonParser) {
            loc = ((JsonParser)processor).currentTokenLocation();
        }
        this._location = JacksonException._nonNullLocation(loc);
    }

    protected JacksonException(Closeable processor, String msg, TokenStreamLocation loc) {
        super(msg);
        this._processor = processor;
        this._location = JacksonException._nonNullLocation(loc);
    }

    private static TokenStreamLocation _nonNullLocation(TokenStreamLocation loc) {
        return loc == null ? TokenStreamLocation.NA : loc;
    }

    public JacksonException withCause(Throwable cause) {
        this.initCause(cause);
        return this;
    }

    public JacksonException clearLocation() {
        this._location = null;
        return this;
    }

    public static JacksonException wrapWithPath(Throwable src, Object refFrom, String refPropertyName) {
        return JacksonException.wrapWithPath(src, new Reference(refFrom, refPropertyName));
    }

    public static JacksonException wrapWithPath(Throwable src, Object refFrom, int index) {
        return JacksonException.wrapWithPath(src, new Reference(refFrom, index));
    }

    public static JacksonException wrapWithPath(Throwable src, Reference ref) {
        return JacksonException.wrapWithPath(src, ref, JacksonException::new);
    }

    public static JacksonException wrapWithPath(Throwable src, Reference ref, BiFunction<String, Throwable, JacksonException> ctor) {
        JacksonException jme;
        if (src instanceof JacksonException) {
            jme = (JacksonException)src;
        } else {
            Object msg = JacksonException._exceptionMessage(src);
            if (msg == null || ((String)msg).isEmpty()) {
                msg = "(was " + src.getClass().getName() + ")";
            }
            jme = ctor.apply((String)msg, src);
        }
        jme.prependPath(ref);
        return jme;
    }

    public static String _exceptionMessage(Throwable t) {
        if (t instanceof JacksonException) {
            return ((JacksonException)t).getOriginalMessage();
        }
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            return t.getCause().getMessage();
        }
        return t.getMessage();
    }

    public JacksonException prependPath(Object referrer, String propertyName) {
        return this.prependPath(new Reference(referrer, propertyName));
    }

    public JacksonException prependPath(Object referrer, int index) {
        return this.prependPath(new Reference(referrer, index));
    }

    public JacksonException prependPath(Reference r) {
        if (this._path == null) {
            this._path = new LinkedList();
        }
        if (this._path.size() < 500) {
            this._path.addFirst(r);
        }
        return this;
    }

    public List<Reference> getPath() {
        if (this._path == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._path);
    }

    public String getPathReference() {
        return this.getPathReference(new StringBuilder()).toString();
    }

    public StringBuilder getPathReference(StringBuilder sb) {
        return this._appendPathDesc(sb);
    }

    public TokenStreamLocation getLocation() {
        return this._location;
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }

    public Object processor() {
        return this._processor;
    }

    protected String messageSuffix() {
        return null;
    }

    @Override
    public String getLocalizedMessage() {
        return this._buildMessage();
    }

    @Override
    public String getMessage() {
        return this._buildMessage();
    }

    protected String _buildMessage() {
        String baseMessage = super.getMessage();
        if (baseMessage == null) {
            baseMessage = "N/A";
        }
        TokenStreamLocation loc = this.getLocation();
        String suffix = this.messageSuffix();
        StringBuilder sb = new StringBuilder(200);
        sb.append(baseMessage);
        if (loc != null || suffix != null) {
            if (suffix != null) {
                sb.append(suffix);
            }
            if (loc != null) {
                sb.append('\n');
                sb.append(" at ");
                sb = loc.toString(sb);
            }
        }
        if (this._path != null) {
            sb = this._appendReferenceChain(sb);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    protected StringBuilder _appendReferenceChain(StringBuilder sb) {
        sb.append(" (through reference chain: ");
        sb = this._appendPathDesc(sb);
        sb.append(')');
        return sb;
    }

    protected StringBuilder _appendPathDesc(StringBuilder sb) {
        if (this._path != null) {
            Iterator it = this._path.iterator();
            while (it.hasNext()) {
                sb.append(((Reference)it.next()).toString());
                if (!it.hasNext()) continue;
                sb.append("->");
            }
        }
        return sb;
    }

    public static class Reference
    implements Serializable {
        private static final long serialVersionUID = 3L;
        protected transient Object _from;
        protected String _propertyName;
        protected int _index = -1;
        protected String _desc;

        protected Reference() {
        }

        public Reference(Object from) {
            this._from = from;
        }

        public Reference(Object from, String propertyName) {
            this._from = from;
            this._propertyName = Objects.requireNonNull(propertyName, "Cannot pass null 'propertyName'");
        }

        public Reference(Object from, int index) {
            this._from = from;
            this._index = index;
        }

        void setPropertyName(String n) {
            this._propertyName = n;
        }

        void setIndex(int ix) {
            this._index = ix;
        }

        void setDescription(String d) {
            this._desc = d;
        }

        public Object from() {
            return this._from;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public int getIndex() {
            return this._index;
        }

        public String getDescription() {
            if (this._desc == null) {
                StringBuilder sb = new StringBuilder();
                if (this._from == null) {
                    sb.append("UNKNOWN");
                } else {
                    Class<?> cls = this._from instanceof Class ? (Class<?>)this._from : this._from.getClass();
                    int arrays = 0;
                    while (cls.isArray()) {
                        cls = cls.getComponentType();
                        ++arrays;
                    }
                    sb.append(cls.getName());
                    while (--arrays >= 0) {
                        sb.append("[]");
                    }
                }
                sb.append('[');
                if (this._propertyName != null) {
                    sb.append('\"');
                    sb.append(this._propertyName);
                    sb.append('\"');
                } else if (this._index >= 0) {
                    sb.append(this._index);
                } else {
                    sb.append('?');
                }
                sb.append(']');
                this._desc = sb.toString();
            }
            return this._desc;
        }

        public String toString() {
            return this.getDescription();
        }

        Object writeReplace() {
            this.getDescription();
            return this;
        }
    }
}

