/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors;

public class LanguagesConstants {
    public static final String[][] LANGUAGES_V55 = new String[][]{{"Afrikaans", "af"}, {"Albanian", "sq"}, {"Amharic", "am"}, {"Anglo-Saxon", "en"}, {"Arabic", "ar"}, {"Armenian", "hy"}, {"Assamese", "as"}, {"Belorusian", "be"}, {"Bengali", "bn"}, {"Braj", "bra"}, {"Bulgarian", "bg"}, {"Burmese", "my"}, {"Cantonese", "zh"}, {"Catalan", "ca"}, {"Catalan_Spn", "ca"}, {"Church-Slavic", "cu"}, {"Czech", "cs"}, {"Danish", "da"}, {"Dogri", "dgr"}, {"Dutch", "nl"}, {"English", "en"}, {"Esperanto", "eo"}, {"Estonian", "et"}, {"Faroese", "fo"}, {"Finnish", "fi"}, {"French", "fr"}, {"Georgian", "ka"}, {"German", "de"}, {"Greek", "el"}, {"Gujarati", "gu"}, {"Hawaiian", "haw"}, {"Hebrew", "he"}, {"Hindi", "hi"}, {"Hungarian", "hu"}, {"Icelandic", "is"}, {"Indonesian", "id"}, {"Italian", "it"}, {"Japanese", "ja"}, {"Kannada", "kn"}, {"Khmer", "km"}, {"Konkani", "kok"}, {"Korean", "ko"}, {"Lahnda", "lah"}, {"Lao", "lo"}, {"Latvian", "lv"}, {"Lithuanian", "lt"}, {"Macedonian", "mk"}, {"Maithili", "mai"}, {"Malayalam", "ml"}, {"Mandrin", "cmn"}, {"Manipuri", "mni"}, {"Marathi", "mr"}, {"Mewari", "mtr"}, {"Navaho", "nv"}, {"Nepali", "ne"}, {"Norwegian", "no"}, {"Oriya", "or"}, {"Pahari", "him"}, {"Pali", "pi"}, {"Panjabi", "pa"}, {"Persian", "fa"}, {"Polish", "pl"}, {"Prakrit", "pra"}, {"Pusto", "ps"}, {"Portuguese", "pt"}, {"Rajasthani", "raj"}, {"Romanian", "ro"}, {"Russian", "ru"}, {"Sanskrit", "sa"}, {"Serb", "sr"}, {"Serbo_Croa", "sh"}, {"Slovak", "sk"}, {"Slovene", "sl"}, {"Spanish", "es"}, {"Swedish", "sv"}, {"Tagalog", "tl"}, {"Tamil", "ta"}, {"Telugu", "te"}, {"Thai", "th"}, {"Tibetan", "bo"}, {"Turkish", "tr"}, {"Ukrainian", "uk"}, {"Urdu", "ur"}, {"Vietnamese", "vi"}, {"Wendic", "wen"}, {"Yiddish", "yi"}};
    public static final String[][] LANGUAGES_V7 = new String[][]{{"af", "Afrikaans"}, {"am", "Amharic"}, {"ar", "Arabic"}, {"as", "Assamese"}, {"be", "Belorusian"}, {"bg", "Bulgarian"}, {"bn", "Bengali"}, {"bo", "Tibetan"}, {"bra", "Braj"}, {"ca", "Catalan"}, {"cmn", "Mandrin"}, {"cs", "Czech"}, {"cu", "Church-Slavic"}, {"da", "Danish"}, {"de", "German"}, {"dgr", "Dogri"}, {"el", "Greek"}, {"en", "English"}, {"eo", "Esperanto"}, {"es", "Spanish"}, {"et", "Estonian"}, {"fa", "Persian"}, {"fi", "Finnish"}, {"fo", "Faroese"}, {"fr", "French"}, {"gu", "Gujarati"}, {"haw", "Hawaiian"}, {"he", "Hebrew"}, {"hi", "Hindi"}, {"him", "Pahari"}, {"hu", "Hungarian"}, {"hy", "Armenian"}, {"id", "Indonesian"}, {"is", "Icelandic"}, {"it", "Italian"}, {"ja", "Japanese"}, {"ka", "Georgian"}, {"km", "Khmer"}, {"kn", "Kannada"}, {"ko", "Korean"}, {"kok", "Konkani"}, {"lah", "Lahnda"}, {"lo", "Lao"}, {"lt", "Lithuanian"}, {"lv", "Latvian"}, {"mai", "Maithili"}, {"mk", "Macedonian"}, {"ml", "Malayalam"}, {"mni", "Manipuri"}, {"mr", "Marathi"}, {"mtr", "Mewari"}, {"my", "Burmese"}, {"ne", "Nepali"}, {"nl", "Dutch"}, {"no", "Norwegian"}, {"nv", "Navaho"}, {"or", "Oriya"}, {"pa", "Panjabi"}, {"pi", "Pali"}, {"pl", "Polish"}, {"pra", "Prakrit"}, {"ps", "Pusto"}, {"pt", "Portuguese"}, {"raj", "Rajasthani"}, {"ro", "Romanian"}, {"ru", "Russian"}, {"sa", "Sanskrit"}, {"sh", "Serbo_Croa"}, {"sk", "Slovak"}, {"sl", "Slovene"}, {"sq", "Albanian"}, {"sr", "Serb"}, {"sv", "Swedish"}, {"ta", "Tamil"}, {"te", "Telugu"}, {"th", "Thai"}, {"tl", "Tagalog"}, {"tr", "Turkish"}, {"uk", "Ukrainian"}, {"ur", "Urdu"}, {"vi", "Vietnamese"}, {"wen", "Wendic"}, {"yi", "Yiddish"}, {"zh", "Cantonese"}};

    private LanguagesConstants() {
    }

    public static String getConvertedLanguage(String version, String value) {
        if ("7.0.13".equals(version)) {
            return LanguagesConstants.getConvertedLanguage(LANGUAGES_V7, value);
        }
        return LanguagesConstants.getConvertedLanguage(LANGUAGES_V55, value);
    }

    private static String getConvertedLanguage(String[][] langues, String value) {
        for (String[] langue : langues) {
            if (!langue[0].equals(value)) continue;
            return langue[1];
        }
        return "";
    }
}

