/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.AssoWrapper;
import ancestris.modules.editors.standard.tools.EventWrapper;
import ancestris.modules.editors.standard.tools.Utils;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import org.openide.util.Exceptions;

public class AssoWrapper55
extends AssoWrapper {
    public static List<AssoWrapper> getList(Indi indi, List<EventWrapper> eventSet) {
        ArrayList<AssoWrapper> ret = new ArrayList<AssoWrapper>();
        List assoList = indi.getProperties(PropertyForeignXRef.class);
        Fam[] fams = indi.getFamiliesWhereSpouse(true);
        for (Fam fam : fams) {
            assoList.addAll(fam.getProperties(PropertyForeignXRef.class));
        }
        for (PropertyForeignXRef assoProp : assoList) {
            PropertyXRef prop = assoProp.getTarget();
            if (!(prop instanceof PropertyAssociation)) continue;
            PropertyAssociation propertyAssociation1 = (PropertyAssociation)prop;
            ret.add(new AssoWrapper55(propertyAssociation1, eventSet));
        }
        return ret;
    }

    public static DefaultListModel<AssoWrapper> getListModel(Indi indi) {
        DefaultListModel<AssoWrapper> ret = new DefaultListModel<AssoWrapper>();
        List assoList = indi.getProperties(PropertyAssociation.class);
        for (PropertyAssociation assoProp : assoList) {
            ret.addElement(new AssoWrapper55(assoProp, null));
        }
        return ret;
    }

    public AssoWrapper55(PropertyAssociation property, List<EventWrapper> eventSet) {
        super(property, eventSet);
    }

    @Override
    protected boolean isGrammar7() {
        return false;
    }

    @Override
    public void update() {
        if (!this.isToBeUpdated()) {
            return;
        }
        this.beneficiaryEntity = this.beneficiaryEventWrapper.eventProperty.getEntity();
        if (this.targetIndi == null || this.targetIndi.getGedcom() == null) {
            try {
                this.targetIndi = (Indi)this.beneficiaryEntity.getGedcom().createEntity("INDI");
                this.propertyAssociation = null;
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.targetIndi.setName(this.targetIndiInfo.firstname, this.targetIndiInfo.lastname);
        this.targetIndi.setSex(this.targetIndiInfo.sex);
        this.updateProperty((Property)this.targetIndi, "OCCU", this.targetIndiInfo.occupation, this.targetIndiInfo.occupationDateUpdate, this.beneficiaryEventWrapper.eventProperty);
        if (this.propertyAssociation == null || this.targetIndiInfo.hasChanged || this.propertyAssociation.getParent() == null) {
            PropertyXRef assoXref = (PropertyXRef)this.targetIndi.addProperty("ASSO", "@");
            this.propertyAssociation = (PropertyAssociation)assoXref;
        } else {
            this.removeLink(this.propertyAssociation);
        }
        Utils.setDistinctValue((Property)this.propertyAssociation, "@" + this.beneficiaryEntity.getId() + "@");
        TagPath anchor = this.getAnchor(this.beneficiaryEventWrapper.eventProperty);
        this.putProperty((Property)this.propertyAssociation, "RELA", this.roleOfTargetEntityForBeneficiary + (String)(anchor == null ? "" : "@" + anchor.toString()));
        try {
            this.propertyAssociation.link();
        }
        catch (Exception ex) {
            this.targetIndi.delProperty((Property)this.propertyAssociation);
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void remove() {
        if (this.targetIndi != null && this.propertyAssociation != null) {
            this.removeLink(this.propertyAssociation);
            this.targetIndi.delProperty((Property)this.propertyAssociation);
        }
    }
}

