from __future__ import annotations

from collections.abc import Callable, Iterator, Mapping, Sequence
from typing import Any, Generic, Self, TypeVar, override

from sage.categories.category import Category
from sage.categories.homset import Homset
from sage.structure.element import Element
from sage.structure.parent import Parent

SectionDomainT = TypeVar("SectionDomainT")
SectionCodomainT = TypeVar("SectionCodomainT")
CompositeDomainT = TypeVar("CompositeDomainT")
CompositeCodomainT = TypeVar("CompositeCodomainT")

class Map[DomainElementT, CodomainElementT](Element):
    _coerce_cost: int
    _is_coercion: bool
    _repr_type_str: str | None
    _category_for: Category | None
    domain: Callable[[], Parent[Any] | None]
    codomain: Callable[[], Parent[Any]]
    _codomain: Parent[Any]

    def __init__(
        self,
        parent: Homset[DomainElementT, CodomainElementT] | DomainElementT,
        codomain: CodomainElementT | None = None,
    ) -> None: ...
    def __copy__(self) -> Self: ...
    def parent(self) -> Homset[DomainElementT, CodomainElementT]: ...
    def _make_weak_references(self) -> None: ...
    def _make_strong_references(self) -> None: ...
    def _update_slots(self, slots: Mapping[str, Any]) -> None: ...
    def _update_slots_test(self, _slots: Mapping[str, Any]) -> None: ...
    def _extra_slots(self) -> dict[str, Any]: ...
    def _extra_slots_test(self) -> dict[str, Any]: ...
    def __reduce__(self) -> tuple[Any, tuple[Any, ...]]: ...
    def _repr_type(self) -> str: ...
    def _repr_defn(self) -> str: ...
    @override
    def _repr_(self) -> str: ...
    def _default_repr_(self) -> str: ...
    def domains(self) -> Iterator[Parent[Any] | None]: ...
    def category_for(self) -> Category: ...
    def __call__(
        self, x: DomainElementT, *args: Any, **kwds: Any
    ) -> CodomainElementT: ...
    def _call_(self, x: DomainElementT) -> CodomainElementT: ...
    def _call_with_args(
        self,
        x: DomainElementT,
        args: Sequence[Any] = ...,
        kwds: Mapping[str, Any] | None = ...,
    ) -> CodomainElementT: ...
    def __mul__(self, right: Map[Any, Any]) -> Map[Any, Any]: ...
    def _composition(self, right: Map[Any, Any]) -> Map[Any, Any]: ...
    def _composition_(self, right: Map[Any, Any], homset: Any) -> Map[Any, Any]: ...
    def pre_compose(self, right: Map[Any, Any]) -> Map[Any, Any]: ...
    def post_compose(self, left: Map[Any, Any]) -> Map[Any, Any]: ...
    def extend_domain(self, new_domain: Any) -> Map[Any, Any]: ...
    def extend_codomain(self, new_codomain: Any) -> Map[Any, Any]: ...
    def is_surjective(self) -> bool: ...
    def _pow_int(self, n: int) -> Map[Any, Any]: ...
    def section(self) -> Map[Any, Any] | None: ...
    def __hash__(self) -> int: ...

class Section(
    Map[SectionCodomainT, SectionDomainT], Generic[SectionDomainT, SectionCodomainT]
):
    _inverse: Map[SectionDomainT, SectionCodomainT]

    def __init__(self, map: Map[SectionDomainT, SectionCodomainT]) -> None: ...
    def _extra_slots(self) -> dict[str, Any]: ...
    def _update_slots(self, slots: Mapping[str, Any]) -> None: ...
    def _repr_type(self) -> str: ...
    def inverse(self) -> Map[SectionDomainT, SectionCodomainT]: ...

class FormalCompositeMap(
    Map[CompositeDomainT, CompositeCodomainT],
    Generic[CompositeDomainT, CompositeCodomainT],
):
    __list: Sequence[Map[Any, Any]]

    def __init__(
        self,
        parent: Any,
        first: Map[Any, Any] | Sequence[Map[Any, Any]],
        second: Map[Any, Any] | None = None,
    ) -> None: ...
    def __copy__(self) -> Self: ...
    def _update_slots(self, slots: Mapping[str, Any]) -> None: ...
    def _extra_slots(self) -> dict[str, Any]: ...
    def __richcmp__(self, other: Any, op: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __getitem__(self, i: int) -> Map[Any, Any]: ...
    def _call_(self, x: CompositeDomainT) -> CompositeCodomainT: ...
    def _call_with_args(
        self,
        x: CompositeDomainT,
        args: Sequence[Any] = ...,
        kwds: Mapping[str, Any] | None = ...,
    ) -> CompositeCodomainT: ...
    def _repr_type(self) -> str: ...
    def _repr_defn(self) -> str: ...
    def first(self) -> Map[Any, Any]: ...
    def then(self) -> Map[Any, Any]: ...
    def is_injective(self) -> bool: ...
    def is_surjective(self) -> bool: ...
    def domains(self) -> Iterator[Parent[Any] | None]: ...
    def section(self) -> Map[Any, Any] | None: ...

def unpickle_map(
    _class: type[Map[Any, Any]],
    parent: Any,
    _dict: Mapping[str, Any],
    _slots: Mapping[str, Any],
) -> Map[Any, Any]: ...
def is_Map(x: Any) -> bool: ...
