from collections.abc import Sequence
from typing import Any

from sage.categories.category import Category
from sage.rings.ring import Ring
from sage.structure.sage_object import SageObject

NameSpec = str | Sequence[str] | None

class CategoryObject(SageObject):
    _names: tuple[str, ...] | None

    def __init__(
        self,
        category: Category | Sequence[Category] | None = None,
        base: Ring | None = None,
    ) -> None: ...
    def __cinit__(self) -> None: ...
    def _init_category_(self, category: Category | Sequence[Category]) -> None: ...
    def _refine_category_(self, category: Category | Sequence[Category]) -> None: ...
    def _is_category_initialized(self) -> bool: ...
    def category(self) -> Category: ...
    def categories(self) -> list[Category]: ...
    def _underlying_class(self) -> Any: ...
    def __gens_dict(self) -> dict[str, Any]: ...
    def gens_dict(self, copy: bool = True) -> dict[str, Any]: ...
    def gens_dict_recursive(self) -> dict[str, Any]: ...
    def objgens(self) -> tuple[Any, Any]: ...
    def objgen(self) -> tuple[Any, Any]: ...
    def _first_ngens(self, n: int) -> Any: ...
    def _defining_names(self) -> Any: ...
    def _assign_names(
        self, names: NameSpec = None, normalize: bool = True, ngens: int | None = None
    ) -> None: ...
    def variable_names(self) -> tuple[str, ...]: ...
    def variable_name(self) -> str: ...
    def _temporarily_change_names(self, names: Any, latex_names: Any) -> Any: ...
    def inject_variables(self, scope: Any = None, verbose: bool = True) -> None: ...
    def base_ring(self) -> Ring: ...
    def base(self) -> Any: ...
    def Hom(self, codomain: Any, category: Any = None) -> Any: ...
    def latex_variable_names(self) -> Any: ...
    def latex_name(self) -> str: ...
    def __getstate__(self) -> dict[str, Any]: ...
    def __setstate__(self, d: dict[str, Any]) -> None: ...
    def __hash__(self) -> int: ...
    def __getattr__(self, name: str) -> Any: ...
    def getattr_from_category(self, name: str) -> Any: ...
    def __dir__(self) -> Any: ...

def normalize_names(ngens: int, names: NameSpec) -> tuple[str, ...]: ...
def certify_names(names: Any) -> bool: ...
