from collections.abc import Generator

class MonoDict[K, V]:
    def __init__(self, data: dict[K, V] | None = None, *, weak_values: bool = False) -> None: ...
    def __len__(self) -> int: ...
    def __contains__(self, k: K) -> bool: ...
    def __getitem__(self, k: K) -> V: ...
    def __setitem__(self, k: K, value: V) -> None: ...
    def __delitem__(self, k: K) -> None: ...
    def items(self) -> Generator[tuple[K, V]]: ...
    def copy(self) -> dict[K, V]: ...
    def __reduce__(self) -> tuple[type[MonoDict], tuple[dict[K, V]]]: ...

class TripleDict[K1, K2, K3, V]:
    def __init__(self, data: dict[tuple[K1, K2, K3], V] | None = None, *, weak_values: bool = False) -> None: ...
    def __len__(self) -> int: ...
    def __contains__(self, k: tuple[K1, K2, K3]) -> bool: ...
    def __getitem__(self, k: tuple[K1, K2, K3]) -> V: ...
    def __setitem__(self, k: tuple[K1, K2, K3], value: V) -> None: ...
    def __delitem__(self, k: tuple[K1, K2, K3]) -> None: ...
    def items(self) -> Generator[tuple[K1, K2, K3], V]: ...
    def copy(self) -> dict[tuple[K1, K2, K3], V]: ...
    def __reduce__(self) -> tuple[type[TripleDict], tuple[dict[tuple[K1, K2, K3], V]]]: ...
