from __future__ import annotations

from collections.abc import Callable, Mapping, Sequence
from typing import Any, Literal, Self

from sage.categories.category import Category
from sage.categories.map import Map
from sage.rings.ring import Ring
from sage.structure.category_object import (
    CategoryObject,
    NameSpec,
)

def is_Parent(x: Any) -> bool: ...

class Parent[ElementT](CategoryObject):
    _element_constructor: Callable[..., Any] | None
    _element_init_pass_parent: bool
    _convert_method_name: str | None
    _initial_coerce_list: list[Any]
    _initial_action_list: list[Any]
    _initial_convert_list: list[Any]
    _coercions_used: bool
    _coerce_from_list: list[Any]
    _registered_domains: list[Any]
    _coerce_from_hash: Any
    _action_list: list[Any]
    _convert_from_list: list[Any]
    _convert_from_hash: Any
    _embedding: Any
    _action_hash: Any
    _cache_an_element: Any

    def __init__(
        self,
        base: Ring | None = None,
        *,
        category: Category | Sequence[Category] | None = None,
        names: NameSpec = None,
        normalize: bool = True,
        facade: Parent[Any] | tuple[Parent[Any], ...] | Literal[True] | None = None,
    ) -> None: ...
    def _init_category_(self, category: Category | Sequence[Category]) -> None: ...
    def _refine_category_(self, category: Category | Sequence[Category]) -> None: ...
    def _unset_category(self) -> None: ...
    @property
    def _abstract_element_class(self) -> type[ElementT]: ...
    @property
    def element_class(self) -> type[ElementT] | Any: ...
    def __make_element_class__(
        self,
        cls: type[ElementT],
        name: str | None = None,
        module: str | None = None,
        inherit: bool | None = None,
    ) -> type[ElementT]: ...
    def _set_element_constructor(self) -> None: ...
    def category(self) -> Category: ...
    def _test_category(self, **options: Any) -> None: ...
    def _test_eq(self, **options: Any) -> None: ...
    def _introspect_coerce(self) -> dict[str, Any]: ...
    def __getstate__(self) -> dict[str, Any]: ...
    def __setstate__(self, d: Mapping[str, Any]) -> None: ...
    def _repr_option(self, key: str) -> Any: ...
    def __call__(self, x: Any = 0, *args: Any, **kwds: Any) -> ElementT: ...
    def __mul__(self, x: Any) -> Any: ...
    def __pow__(self, x: Any, mod: Any) -> Any: ...
    def __contains__(self, x: Any) -> bool: ...
    def coerce(self, x: Any) -> ElementT: ...
    def __bool__(self) -> bool: ...
    def __getitem__(self, n: int | slice) -> ElementT: ...
    def _is_valid_homomorphism_(
        self, codomain: Any, im_gens: Any, base_map: Any | None = None
    ) -> bool: ...
    def Hom(self, codomain: Any, category: Category | None = None) -> Any: ...
    def hom(
        self,
        im_gens: Any,
        codomain: Any | None = None,
        check: bool | None = None,
        base_map: Any | None = None,
        category: Category | None = None,
        **kwds: Any,
    ) -> Any: ...
    def _populate_coercion_lists_(
        self,
        coerce_list: Sequence[Any] | None = ...,
        action_list: Sequence[Any] | None = ...,
        convert_list: Sequence[Any] | None = ...,
        embedding: Any | None = None,
        convert_method_name: str | None = None,
        element_constructor: Callable[..., Any] | None = None,
        init_no_parent: bool | None = None,
        unpickling: bool = False,
    ) -> None: ...
    def _unset_coercions_used(self) -> None: ...
    def _unset_embedding(self) -> None: ...
    def _is_coercion_cached(self, domain: Any) -> bool: ...
    def _is_conversion_cached(self, domain: Any) -> bool: ...
    def _remove_from_coerce_cache(self, domain: Any) -> None: ...
    def register_coercion(self, mor: Any) -> None: ...
    def register_action(self, action: Any) -> None: ...
    def register_conversion(self, mor: Any) -> None: ...
    def register_embedding(self, embedding: Any) -> None: ...
    def coerce_embedding(self) -> Any: ...
    def _generic_coerce_map(self, S: Any) -> Map[Any, Any]: ...
    def _generic_convert_map(
        self, S: Any, category: Category | None = None
    ) -> Map[Any, Any]: ...
    def _convert_method_map(
        self, S: Any, method_name: str | None = None
    ) -> Map[Any, Any]: ...
    def _coerce_map_via(self, v: Sequence[Any], S: Any) -> Map[Any, Any]: ...
    def has_coerce_map_from(self, S: Any) -> bool: ...
    def _coerce_map_from_(self, S: Any) -> Any: ...
    def coerce_map_from(self, S: Any) -> Map[Any, Any] | None: ...
    def _internal_coerce_map_from(self, S: Any) -> Map[Any, Any] | None: ...
    def convert_map_from(self, S: Any) -> Map[Any, Any] | None: ...
    def _internal_convert_map_from(self, S: Any) -> Map[Any, Any] | None: ...
    def _convert_map_from_(
        self, S: Any
    ) -> Map[Any, Any] | Callable[..., Any] | bool | None: ...
    def get_action(
        self,
        S: Any,
        op: Callable[..., Any] = ...,
        self_on_left: bool = True,
        self_el: Any = None,
        S_el: Any = None,
    ) -> Any: ...
    def _get_action_(
        self, S: Any, op: Callable[..., Any], self_on_left: bool
    ) -> Any: ...
    def an_element(self) -> ElementT: ...
    def _an_element_(self) -> ElementT: ...
    def is_exact(self) -> bool: ...
    def _is_numerical(self) -> bool: ...
    def _is_real_numerical(self) -> bool: ...

class Set_generic(Parent[Any]):
    def object(self) -> Self: ...
    def __bool__(self) -> bool: ...

class EltPair:
    x: Any
    y: Any
    tag: Any

    def __init__(self, x: Any, y: Any, tag: Any) -> None: ...
    def __richcmp__(self, other: EltPair, op: int) -> bool: ...
    def __hash__(self) -> int: ...
    def short_repr(self) -> tuple[Any, str, str]: ...
    def __repr__(self) -> str: ...
