from __future__ import annotations

from collections.abc import Hashable
from typing import Any, Self
from unittest import TestCase

from sage.categories.category import Category
from sage.typeset.ascii_art import AsciiArt
from sage.typeset.unicode_art import UnicodeArt

_interface_init_with_interface: set[str]

load: Any
loads: Any
dumps: Any
save: Any
unpickle_all: Any
unpickle_global: Any
unpickle_override: Any

CacheKey = Hashable | tuple[Any, ...]

class SageObject:
    _SageObject__custom_name: str | None

    def _test_new(self, **options: Any) -> None: ...
    def rename(self, x: Any | None = None) -> None: ...
    def reset_name(self) -> None: ...
    def get_custom_name(self) -> str | None: ...
    def __repr__(self) -> str: ...
    def _ascii_art_(self) -> AsciiArt: ...
    def _unicode_art_(self) -> UnicodeArt: ...
    def __hash__(self) -> int: ...
    def _cache_key(self) -> CacheKey: ...
    def save(self, filename: str | None = None, compress: bool = True) -> None: ...
    def dump(self, filename: str, compress: bool = True) -> None: ...
    def dumps(self, compress: bool = True) -> bytes: ...
    def category(self) -> Category: ...
    def _test_category(self, **options: Any) -> None: ...
    def parent(self) -> type[Any]: ...
    def _tester(self, **options: Any) -> TestCase: ...
    def _test_not_implemented_methods(self, **options: Any) -> None: ...
    def _test_pickling(self, **options: Any) -> None: ...
    def _sage_(self) -> Self: ...
    def _interface_(self, I: Any) -> Any: ...
    def _interface_init_(self, I: Any | None = None) -> str: ...
    def _interface_is_cached_(self) -> bool: ...
    def _gap_(self, G: Any | None = None) -> Any: ...
    def _gap_init_(self) -> str: ...
    def _libgap_(self) -> Any: ...
    def _gp_(self, G: Any | None = None) -> Any: ...
    def _gp_init_(self) -> str: ...
    def _kash_(self, G: Any | None = None) -> Any: ...
    def _kash_init_(self) -> str: ...
    def _axiom_(self, G: Any | None = None) -> Any: ...
    def _axiom_init_(self) -> str: ...
    def _fricas_(self, G: Any | None = None) -> Any: ...
    def _fricas_init_(self) -> str: ...
    def _giac_(self, G: Any | None = None) -> Any: ...
    def _giac_init_(self) -> str: ...
    def _maxima_(self, G: Any | None = None) -> Any: ...
    def _maxima_init_(self) -> str: ...
    def _maxima_lib_(self, G: Any | None = None) -> Any: ...
    def _maxima_lib_init_(self) -> str: ...
    def _magma_init_(self, magma: Any) -> str: ...
    def _macaulay2_(self, G: Any | None = None) -> Any: ...
    def _macaulay2_init_(self, macaulay2: Any | None = None) -> str: ...
    def _maple_(self, G: Any | None = None) -> Any: ...
    def _maple_init_(self) -> str: ...
    def _mathematica_(self, G: Any | None = None) -> Any: ...
    def _mathematica_init_(self) -> str: ...
    def _mathics_(self, G: Any | None = None) -> Any: ...
    _mathics_init_ = _mathematica_init_
    def _octave_(self, G: Any | None = None) -> Any: ...
    def _octave_init_(self) -> str: ...
    def _polymake_(self, G: Any | None = None) -> Any: ...
    def _polymake_init_(self) -> str: ...
    def _r_init_(self) -> str: ...
    def _singular_(self, G: Any | None = None) -> Any: ...
    def _singular_init_(self) -> str: ...
    def __pari__(self) -> Any: ...
    def _pari_init_(self) -> str: ...
    def _regina_(self, G: Any | None = None) -> Any: ...
    def _regina_init_(self) -> str: ...
