# LinearAlgebraForCAP, single 11
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("linearalgebraforcap11.tst");

# doc/_Chapter_Examples_and_Tests.xml:507-548
gap> field := HomalgFieldOfRationals( );;
gap> vec := MatrixCategory( field );;
gap> A := MatrixCategoryObject( vec, 3 );;
gap> B := MatrixCategoryObject( vec, 2 );;
gap> alpha := VectorSpaceMorphism( B, HomalgMatrix( [ [ 1, -1, 1 ], [ 1, 1, 1 ] ], 2, 3, field ), A );;
gap> beta := VectorSpaceMorphism( B, HomalgMatrix( [ [ 1, 2, 1 ], [ 2, 1, 1 ] ], 2, 3, field ), A );;
gap> m := MorphismFromFiberProductToSink( [ alpha, beta ] );;
gap> IsCongruentForMorphisms(
>     m,
>     PreCompose( ProjectionInFactorOfFiberProduct( [ alpha, beta ], 1 ), alpha )
> );
true
gap> IsCongruentForMorphisms(
>     m,
>     PreCompose( ProjectionInFactorOfFiberProduct( [ alpha, beta ], 2 ), beta )
> );
true
gap> IsCongruentForMorphisms(
> MorphismFromKernelObjectToSink( alpha ),
>     PreCompose( KernelEmbedding( alpha ), alpha )
> );
true
gap> alpha_p := DualOnMorphisms( alpha );;
gap> beta_p := DualOnMorphisms( beta );;
gap> m_p := MorphismFromSourceToPushout( [ alpha_p, beta_p ] );;
gap> IsCongruentForMorphisms(
>     m_p,
>     PreCompose( alpha_p, InjectionOfCofactorOfPushout( [ alpha_p, beta_p ], 1 ) )
> );
true
gap> IsCongruentForMorphisms(
>     m_p,
>     PreCompose( beta_p, InjectionOfCofactorOfPushout( [ alpha_p, beta_p ], 2 ) )
> );
true
gap> IsCongruentForMorphisms(
>     MorphismFromSourceToCokernelObject( alpha_p ),
>     PreCompose( alpha_p, CokernelProjection( alpha_p ) )
> );
true

#
gap> STOP_TEST("linearalgebraforcap11.tst", 1);
