// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme2p2 -target-feature +sve -verify=streaming-guard

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="" streaming_guard="sme,sme2p2" flags="streaming-only"

void test(void) {
  svfloat16_t svfloat16_t_val;
  svfloat16x2_t svfloat16x2_t_val;
  svfloat16x4_t svfloat16x4_t_val;
  svfloat32_t svfloat32_t_val;
  svfloat32x2_t svfloat32x2_t_val;
  svfloat32x4_t svfloat32x4_t_val;
  svfloat64_t svfloat64_t_val;
  svfloat64x2_t svfloat64x2_t_val;
  svfloat64x4_t svfloat64x4_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat16x2_t_val, svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat16x2_t_val, svfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat16x4_t_val, svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat16x4_t_val, svfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat32x2_t_val, svfloat32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat32x2_t_val, svfloat32x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat32x4_t_val, svfloat32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat32x4_t_val, svfloat32x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat64x2_t_val, svfloat64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat64x2_t_val, svfloat64x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat64x4_t_val, svfloat64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat64x4_t_val, svfloat64x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_f16_x2(svfloat16x2_t_val, svfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_f16_x4(svfloat16x4_t_val, svfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_f32_x2(svfloat32x2_t_val, svfloat32x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_f32_x4(svfloat32x4_t_val, svfloat32x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_f64_x2(svfloat64x2_t_val, svfloat64x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_f64_x4(svfloat64x4_t_val, svfloat64x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_f16_x2(svfloat16x2_t_val, svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_f16_x4(svfloat16x4_t_val, svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_f32_x2(svfloat32x2_t_val, svfloat32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_f32_x4(svfloat32x4_t_val, svfloat32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_f64_x2(svfloat64x2_t_val, svfloat64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_f64_x4(svfloat64x4_t_val, svfloat64_t_val);
}

void test_streaming(void) __arm_streaming{
  svfloat16_t svfloat16_t_val;
  svfloat16x2_t svfloat16x2_t_val;
  svfloat16x4_t svfloat16x4_t_val;
  svfloat32_t svfloat32_t_val;
  svfloat32x2_t svfloat32x2_t_val;
  svfloat32x4_t svfloat32x4_t_val;
  svfloat64_t svfloat64_t_val;
  svfloat64x2_t svfloat64x2_t_val;
  svfloat64x4_t svfloat64x4_t_val;

  svmul(svfloat16x2_t_val, svfloat16_t_val);
  svmul(svfloat16x2_t_val, svfloat16x2_t_val);
  svmul(svfloat16x4_t_val, svfloat16_t_val);
  svmul(svfloat16x4_t_val, svfloat16x4_t_val);
  svmul(svfloat32x2_t_val, svfloat32_t_val);
  svmul(svfloat32x2_t_val, svfloat32x2_t_val);
  svmul(svfloat32x4_t_val, svfloat32_t_val);
  svmul(svfloat32x4_t_val, svfloat32x4_t_val);
  svmul(svfloat64x2_t_val, svfloat64_t_val);
  svmul(svfloat64x2_t_val, svfloat64x2_t_val);
  svmul(svfloat64x4_t_val, svfloat64_t_val);
  svmul(svfloat64x4_t_val, svfloat64x4_t_val);
  svmul_f16_x2(svfloat16x2_t_val, svfloat16x2_t_val);
  svmul_f16_x4(svfloat16x4_t_val, svfloat16x4_t_val);
  svmul_f32_x2(svfloat32x2_t_val, svfloat32x2_t_val);
  svmul_f32_x4(svfloat32x4_t_val, svfloat32x4_t_val);
  svmul_f64_x2(svfloat64x2_t_val, svfloat64x2_t_val);
  svmul_f64_x4(svfloat64x4_t_val, svfloat64x4_t_val);
  svmul_single_f16_x2(svfloat16x2_t_val, svfloat16_t_val);
  svmul_single_f16_x4(svfloat16x4_t_val, svfloat16_t_val);
  svmul_single_f32_x2(svfloat32x2_t_val, svfloat32_t_val);
  svmul_single_f32_x4(svfloat32x4_t_val, svfloat32_t_val);
  svmul_single_f64_x2(svfloat64x2_t_val, svfloat64_t_val);
  svmul_single_f64_x4(svfloat64x4_t_val, svfloat64_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  svfloat16_t svfloat16_t_val;
  svfloat16x2_t svfloat16x2_t_val;
  svfloat16x4_t svfloat16x4_t_val;
  svfloat32_t svfloat32_t_val;
  svfloat32x2_t svfloat32x2_t_val;
  svfloat32x4_t svfloat32x4_t_val;
  svfloat64_t svfloat64_t_val;
  svfloat64x2_t svfloat64x2_t_val;
  svfloat64x4_t svfloat64x4_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat16x2_t_val, svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat16x2_t_val, svfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat16x4_t_val, svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat16x4_t_val, svfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat32x2_t_val, svfloat32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat32x2_t_val, svfloat32x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat32x4_t_val, svfloat32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat32x4_t_val, svfloat32x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat64x2_t_val, svfloat64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat64x2_t_val, svfloat64x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat64x4_t_val, svfloat64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svfloat64x4_t_val, svfloat64x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_f16_x2(svfloat16x2_t_val, svfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_f16_x4(svfloat16x4_t_val, svfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_f32_x2(svfloat32x2_t_val, svfloat32x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_f32_x4(svfloat32x4_t_val, svfloat32x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_f64_x2(svfloat64x2_t_val, svfloat64x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_f64_x4(svfloat64x4_t_val, svfloat64x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_f16_x2(svfloat16x2_t_val, svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_f16_x4(svfloat16x4_t_val, svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_f32_x2(svfloat32x2_t_val, svfloat32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_f32_x4(svfloat32x4_t_val, svfloat32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_f64_x2(svfloat64x2_t_val, svfloat64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_f64_x4(svfloat64x4_t_val, svfloat64_t_val);
}
