// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _ --version 2
// REQUIRES: amdgpu-registered-target

// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fopenmp-is-target-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --check-prefix=IR-GPU

// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -fopenmp -emit-llvm %s -o - | FileCheck %s --check-prefix=IR

// Check same results after serialization round-trip
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -fopenmp -emit-pch -o %t %s
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -fopenmp -include-pch %t -emit-llvm %s -o - | FileCheck %s --check-prefix=IR-PCH
extern int foo(int i);

// expected-no-diagnostics

#ifndef HEADER
#define HEADER
int N = 100000;
int main()
{
  int i;
  int a[N];
  int b[N];

  // Presence of call. Cannot use 'parallel for', must use 'distribute' when
  // assume-no-neseted-parallelism isn't specified.
  #pragma omp target teams loop
  for (i=0; i < N; i++) {
    for (int j=0; j < N; j++) {
      a[i] = b[i] * N + foo(j);
    }
  }
  return 0;
}
#endif
// IR-GPU-LABEL: define weak_odr protected amdgpu_kernel void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l27
// IR-GPU-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR0:[0-9]+]] {
// IR-GPU-NEXT:  entry:
// IR-GPU-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// IR-GPU-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// IR-GPU-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR2]] to ptr
// IR-GPU-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// IR-GPU-NEXT:    [[N_CASTED_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_CASTED]] to ptr
// IR-GPU-NEXT:    [[DOTZERO_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
// IR-GPU-NEXT:    [[DOTTHREADID_TEMP__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTTHREADID_TEMP_]] to ptr
// IR-GPU-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_target_init(ptr addrspacecast (ptr addrspace(1) @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l27_kernel_environment to ptr), ptr [[DYN_PTR]])
// IR-GPU-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP4]], -1
// IR-GPU-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// IR-GPU:       user_code.entry:
// IR-GPU-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_global_thread_num(ptr addrspacecast (ptr addrspace(1) @[[GLOB1:[0-9]+]] to ptr))
// IR-GPU-NEXT:    [[TMP6:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP6]], ptr [[N_CASTED_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP7:%.*]] = load i64, ptr [[N_CASTED_ASCAST]], align 8
// IR-GPU-NEXT:    store i32 0, ptr [[DOTZERO_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP5]], ptr [[DOTTHREADID_TEMP__ASCAST]], align 4
// IR-GPU-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l27_omp_outlined(ptr [[DOTTHREADID_TEMP__ASCAST]], ptr [[DOTZERO_ADDR_ASCAST]], i64 [[TMP7]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]]) #[[ATTR2:[0-9]+]]
// IR-GPU-NEXT:    call void @__kmpc_target_deinit()
// IR-GPU-NEXT:    ret void
// IR-GPU:       worker.exit:
// IR-GPU-NEXT:    ret void
//
//
// IR-GPU-LABEL: define internal void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l27_omp_outlined
// IR-GPU-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR1:[0-9]+]] {
// IR-GPU-NEXT:  entry:
// IR-GPU-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[TMP:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[I5:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[J:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTGLOBAL_TID__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTGLOBAL_TID__ADDR]] to ptr
// IR-GPU-NEXT:    [[DOTBOUND_TID__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTBOUND_TID__ADDR]] to ptr
// IR-GPU-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// IR-GPU-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR2]] to ptr
// IR-GPU-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// IR-GPU-NEXT:    [[TMP_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[TMP]] to ptr
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_]] to ptr
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_3]] to ptr
// IR-GPU-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_COMB_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_COMB_LB]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_COMB_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_COMB_UB]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_STRIDE_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_STRIDE]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_IS_LAST_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IS_LAST]] to ptr
// IR-GPU-NEXT:    [[I5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I5]] to ptr
// IR-GPU-NEXT:    [[J_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[J]] to ptr
// IR-GPU-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-GPU-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-GPU-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-GPU-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// IR-GPU-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-GPU:       omp.precond.then:
// IR-GPU-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// IR-GPU-NEXT:    call void @__kmpc_distribute_static_init_4(ptr addrspacecast (ptr addrspace(1) @[[GLOB2:[0-9]+]] to ptr), i32 [[TMP9]], i32 92, ptr [[DOTOMP_IS_LAST_ASCAST]], ptr [[DOTOMP_COMB_LB_ASCAST]], ptr [[DOTOMP_COMB_UB_ASCAST]], ptr [[DOTOMP_STRIDE_ASCAST]], i32 1, i32 1)
// IR-GPU-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// IR-GPU-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-GPU:       cond.true:
// IR-GPU-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[COND_END:%.*]]
// IR-GPU:       cond.false:
// IR-GPU-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[COND_END]]
// IR-GPU:       cond.end:
// IR-GPU-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// IR-GPU-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_LB_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-GPU:       omp.inner.for.cond:
// IR-GPU-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// IR-GPU-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-GPU:       omp.inner.for.body:
// IR-GPU-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// IR-GPU-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// IR-GPU-NEXT:    store i32 [[ADD]], ptr [[I5_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 0, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[FOR_COND:%.*]]
// IR-GPU:       for.cond:
// IR-GPU-NEXT:    [[TMP18:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP19:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    [[CMP8:%.*]] = icmp slt i32 [[TMP18]], [[TMP19]]
// IR-GPU-NEXT:    br i1 [[CMP8]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// IR-GPU:       for.body:
// IR-GPU-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I5_ASCAST]], align 4
// IR-GPU-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// IR-GPU-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-GPU-NEXT:    [[TMP21:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-GPU-NEXT:    [[TMP22:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[TMP21]], [[TMP22]]
// IR-GPU-NEXT:    [[TMP23:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z3fooi(i32 noundef [[TMP23]]) #[[ATTR4:[0-9]+]]
// IR-GPU-NEXT:    [[ADD10:%.*]] = add nsw i32 [[MUL9]], [[CALL]]
// IR-GPU-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I5_ASCAST]], align 4
// IR-GPU-NEXT:    [[IDXPROM11:%.*]] = sext i32 [[TMP24]] to i64
// IR-GPU-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM11]]
// IR-GPU-NEXT:    store i32 [[ADD10]], ptr [[ARRAYIDX12]], align 4
// IR-GPU-NEXT:    br label [[FOR_INC:%.*]]
// IR-GPU:       for.inc:
// IR-GPU-NEXT:    [[TMP25:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP25]], 1
// IR-GPU-NEXT:    store i32 [[INC]], ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// IR-GPU:       for.end:
// IR-GPU-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR-GPU:       omp.body.continue:
// IR-GPU-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-GPU:       omp.inner.for.inc:
// IR-GPU-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP26]], 1
// IR-GPU-NEXT:    store i32 [[ADD13]], ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-GPU:       omp.inner.for.end:
// IR-GPU-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-GPU:       omp.loop.exit:
// IR-GPU-NEXT:    [[TMP27:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP28:%.*]] = load i32, ptr [[TMP27]], align 4
// IR-GPU-NEXT:    call void @__kmpc_distribute_static_fini(ptr addrspacecast (ptr addrspace(1) @[[GLOB2]] to ptr), i32 [[TMP28]])
// IR-GPU-NEXT:    br label [[OMP_PRECOND_END]]
// IR-GPU:       omp.precond.end:
// IR-GPU-NEXT:    ret void
//
//
// IR-LABEL: define dso_local noundef i32 @main
// IR-SAME: () #[[ATTR0:[0-9]+]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// IR-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// IR-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i64, align 8
// IR-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// IR-NEXT:    [[TMP0:%.*]] = load i32, ptr @N, align 4
// IR-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// IR-NEXT:    [[TMP2:%.*]] = call ptr @llvm.stacksave.p0()
// IR-NEXT:    store ptr [[TMP2]], ptr [[SAVED_STACK]], align 8
// IR-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 16
// IR-NEXT:    store i64 [[TMP1]], ptr [[__VLA_EXPR0]], align 8
// IR-NEXT:    [[TMP3:%.*]] = load i32, ptr @N, align 4
// IR-NEXT:    [[TMP4:%.*]] = zext i32 [[TMP3]] to i64
// IR-NEXT:    [[VLA1:%.*]] = alloca i32, i64 [[TMP4]], align 16
// IR-NEXT:    store i64 [[TMP4]], ptr [[__VLA_EXPR1]], align 8
// IR-NEXT:    [[TMP5:%.*]] = load i32, ptr @N, align 4
// IR-NEXT:    store i32 [[TMP5]], ptr [[N_CASTED]], align 4
// IR-NEXT:    [[TMP6:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l27(i64 [[TMP6]], i64 [[TMP1]], ptr [[VLA]], i64 [[TMP4]], ptr [[VLA1]]) #[[ATTR3:[0-9]+]]
// IR-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// IR-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// IR-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP7]])
// IR-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RETVAL]], align 4
// IR-NEXT:    ret i32 [[TMP8]]
//
//
// IR-LABEL: define internal void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l27
// IR-SAME: (i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2:[0-9]+]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP4]], ptr [[N_CASTED]], align 4
// IR-NEXT:    [[TMP5:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB2:[0-9]+]], i32 5, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l27.omp_outlined, i64 [[TMP5]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-NEXT:    ret void
//
//
// IR-LABEL: define internal void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l27.omp_outlined
// IR-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// IR-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// IR-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-NEXT:    [[I5:%.*]] = alloca i32, align 4
// IR-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    store i32 0, ptr [[I]], align 4
// IR-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// IR-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR:       omp.precond.then:
// IR-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// IR-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// IR-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// IR-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// IR-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// IR-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR:       cond.true:
// IR-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    br label [[COND_END:%.*]]
// IR:       cond.false:
// IR-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    br label [[COND_END]]
// IR:       cond.end:
// IR-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// IR-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// IR-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR:       omp.inner.for.cond:
// IR-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// IR-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR:       omp.inner.for.body:
// IR-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// IR-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// IR-NEXT:    store i32 [[ADD]], ptr [[I5]], align 4
// IR-NEXT:    store i32 0, ptr [[J]], align 4
// IR-NEXT:    br label [[FOR_COND:%.*]]
// IR:       for.cond:
// IR-NEXT:    [[TMP18:%.*]] = load i32, ptr [[J]], align 4
// IR-NEXT:    [[TMP19:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    [[CMP8:%.*]] = icmp slt i32 [[TMP18]], [[TMP19]]
// IR-NEXT:    br i1 [[CMP8]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// IR:       for.body:
// IR-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I5]], align 4
// IR-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// IR-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-NEXT:    [[TMP21:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-NEXT:    [[TMP22:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[TMP21]], [[TMP22]]
// IR-NEXT:    [[TMP23:%.*]] = load i32, ptr [[J]], align 4
// IR-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z3fooi(i32 noundef [[TMP23]])
// IR-NEXT:    [[ADD10:%.*]] = add nsw i32 [[MUL9]], [[CALL]]
// IR-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I5]], align 4
// IR-NEXT:    [[IDXPROM11:%.*]] = sext i32 [[TMP24]] to i64
// IR-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM11]]
// IR-NEXT:    store i32 [[ADD10]], ptr [[ARRAYIDX12]], align 4
// IR-NEXT:    br label [[FOR_INC:%.*]]
// IR:       for.inc:
// IR-NEXT:    [[TMP25:%.*]] = load i32, ptr [[J]], align 4
// IR-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP25]], 1
// IR-NEXT:    store i32 [[INC]], ptr [[J]], align 4
// IR-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// IR:       for.end:
// IR-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR:       omp.body.continue:
// IR-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR:       omp.inner.for.inc:
// IR-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP26]], 1
// IR-NEXT:    store i32 [[ADD13]], ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR:       omp.inner.for.end:
// IR-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR:       omp.loop.exit:
// IR-NEXT:    [[TMP27:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP28:%.*]] = load i32, ptr [[TMP27]], align 4
// IR-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP28]])
// IR-NEXT:    br label [[OMP_PRECOND_END]]
// IR:       omp.precond.end:
// IR-NEXT:    ret void
//
//
// IR-PCH-LABEL: define dso_local noundef i32 @main
// IR-PCH-SAME: () #[[ATTR0:[0-9]+]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// IR-PCH-NEXT:    [[TMP0:%.*]] = load i32, ptr @N, align 4
// IR-PCH-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// IR-PCH-NEXT:    [[TMP2:%.*]] = call ptr @llvm.stacksave.p0()
// IR-PCH-NEXT:    store ptr [[TMP2]], ptr [[SAVED_STACK]], align 8
// IR-PCH-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 16
// IR-PCH-NEXT:    store i64 [[TMP1]], ptr [[__VLA_EXPR0]], align 8
// IR-PCH-NEXT:    [[TMP3:%.*]] = load i32, ptr @N, align 4
// IR-PCH-NEXT:    [[TMP4:%.*]] = zext i32 [[TMP3]] to i64
// IR-PCH-NEXT:    [[VLA1:%.*]] = alloca i32, i64 [[TMP4]], align 16
// IR-PCH-NEXT:    store i64 [[TMP4]], ptr [[__VLA_EXPR1]], align 8
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i32, ptr @N, align 4
// IR-PCH-NEXT:    store i32 [[TMP5]], ptr [[N_CASTED]], align 4
// IR-PCH-NEXT:    [[TMP6:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-PCH-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l27(i64 [[TMP6]], i64 [[TMP1]], ptr [[VLA]], i64 [[TMP4]], ptr [[VLA1]]) #[[ATTR3:[0-9]+]]
// IR-PCH-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// IR-PCH-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// IR-PCH-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP7]])
// IR-PCH-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RETVAL]], align 4
// IR-PCH-NEXT:    ret i32 [[TMP8]]
//
//
// IR-PCH-LABEL: define internal void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l27
// IR-PCH-SAME: (i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2:[0-9]+]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP4]], ptr [[N_CASTED]], align 4
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-PCH-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB2:[0-9]+]], i32 5, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l27.omp_outlined, i64 [[TMP5]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-PCH-NEXT:    ret void
//
//
// IR-PCH-LABEL: define internal void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l27.omp_outlined
// IR-PCH-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[I5:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-PCH-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-PCH-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-PCH-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[I]], align 4
// IR-PCH-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// IR-PCH-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-PCH:       omp.precond.then:
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// IR-PCH-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-PCH-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// IR-PCH-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// IR-PCH-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-PCH:       cond.true:
// IR-PCH-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    br label [[COND_END:%.*]]
// IR-PCH:       cond.false:
// IR-PCH-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    br label [[COND_END]]
// IR-PCH:       cond.end:
// IR-PCH-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// IR-PCH-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// IR-PCH-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-PCH:       omp.inner.for.cond:
// IR-PCH-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// IR-PCH-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-PCH:       omp.inner.for.body:
// IR-PCH-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// IR-PCH-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// IR-PCH-NEXT:    store i32 [[ADD]], ptr [[I5]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[J]], align 4
// IR-PCH-NEXT:    br label [[FOR_COND:%.*]]
// IR-PCH:       for.cond:
// IR-PCH-NEXT:    [[TMP18:%.*]] = load i32, ptr [[J]], align 4
// IR-PCH-NEXT:    [[TMP19:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    [[CMP8:%.*]] = icmp slt i32 [[TMP18]], [[TMP19]]
// IR-PCH-NEXT:    br i1 [[CMP8]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// IR-PCH:       for.body:
// IR-PCH-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I5]], align 4
// IR-PCH-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// IR-PCH-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-PCH-NEXT:    [[TMP21:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-PCH-NEXT:    [[TMP22:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[TMP21]], [[TMP22]]
// IR-PCH-NEXT:    [[TMP23:%.*]] = load i32, ptr [[J]], align 4
// IR-PCH-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z3fooi(i32 noundef [[TMP23]])
// IR-PCH-NEXT:    [[ADD10:%.*]] = add nsw i32 [[MUL9]], [[CALL]]
// IR-PCH-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I5]], align 4
// IR-PCH-NEXT:    [[IDXPROM11:%.*]] = sext i32 [[TMP24]] to i64
// IR-PCH-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM11]]
// IR-PCH-NEXT:    store i32 [[ADD10]], ptr [[ARRAYIDX12]], align 4
// IR-PCH-NEXT:    br label [[FOR_INC:%.*]]
// IR-PCH:       for.inc:
// IR-PCH-NEXT:    [[TMP25:%.*]] = load i32, ptr [[J]], align 4
// IR-PCH-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP25]], 1
// IR-PCH-NEXT:    store i32 [[INC]], ptr [[J]], align 4
// IR-PCH-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// IR-PCH:       for.end:
// IR-PCH-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR-PCH:       omp.body.continue:
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-PCH:       omp.inner.for.inc:
// IR-PCH-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP26]], 1
// IR-PCH-NEXT:    store i32 [[ADD13]], ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-PCH:       omp.inner.for.end:
// IR-PCH-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-PCH:       omp.loop.exit:
// IR-PCH-NEXT:    [[TMP27:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP28:%.*]] = load i32, ptr [[TMP27]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP28]])
// IR-PCH-NEXT:    br label [[OMP_PRECOND_END]]
// IR-PCH:       omp.precond.end:
// IR-PCH-NEXT:    ret void
//
